<?php

// website-generator.php

session_start();

// Base path + GA config
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/ga4-config.php';

// Auth guard
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: ' . url('login.php'));
    exit;
}

?>

<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">

    <title>Strategic Website Architecture - Business Intelligence Platform</title>

    <?php 

    // Include GTM head script

    echo GA4Config::getHeadScript();

    echo GA4Config::trackPageView('website_generator');

    ?>

    <!-- Ensure relative resources resolve under subdirectory installs -->
    <base href="<?= htmlspecialchars(rtrim(url('ad-generator/'), '/') . '/', ENT_QUOTES, 'UTF-8') ?>">

    <script src="https://cdn.tailwindcss.com"></script>

    <script src="universal-data-handler.js"></script>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-SLMXCVWD2T"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());

      gtag('config', 'G-SLMXCVWD2T');
    </script>

    <style>

        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&family=Poppins:wght@400;500;600;700;800;900&display=swap');

        body { font-family: 'Inter', sans-serif; }

        

        /* Enhanced animations and effects */

        .spinner { border: 4px solid #f3f3f3; border-top: 4px solid #4F46E5; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }

        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        
        /* Mobile-First Responsive Design */
        @media (max-width: 768px) {
            .container { padding: 0.5rem !important; }
            .mobile-card { 
                padding: 1rem !important; 
                margin-bottom: 0.75rem;
                border-radius: 0.75rem !important;
            }
            .mobile-title { font-size: 1.125rem !important; line-height: 1.3; margin-bottom: 0.75rem; }
            .mobile-desc { font-size: 0.875rem !important; line-height: 1.4; }
            .mobile-grid { grid-template-columns: 1fr !important; gap: 0.75rem !important; }
            .mobile-header { margin-bottom: 1.5rem !important; }
            .mobile-title-main { font-size: 1.75rem !important; line-height: 1.2; }
            .mobile-subtitle { font-size: 0.875rem !important; margin-top: 0.5rem !important; }
            
            /* Mobile form improvements */
            .form-input, .form-textarea, .form-select {
                min-height: 44px;
                font-size: 16px; /* Prevents zoom on iOS */
                padding: 0.75rem;
            }
            
            /* Mobile button improvements */
            .btn {
                min-height: 44px;
                padding: 0.75rem 1rem;
                font-size: 1rem;
                width: 100%;
                margin-bottom: 0.5rem;
            }
            
            /* Mobile navigation */
            .nav-item {
                padding: 0.75rem 0.5rem;
                min-height: 44px;
            }
        }
        
        @media (max-width: 480px) {
            .mobile-title-main { font-size: 1.5rem !important; }
            .mobile-card { padding: 0.75rem !important; }
            .mobile-title { font-size: 1rem !important; }
            .mobile-desc { font-size: 0.8rem !important; }
            .mobile-header { margin-bottom: 1rem !important; }
        }
        
        /* Touch device optimizations */
        @media (hover: none) and (pointer: coarse) {
            .card:hover { transform: none; }
            .card:active { transform: scale(0.98); transition: transform 0.1s ease; }
            .btn:hover { transform: none; }
            .btn:active { transform: scale(0.98); transition: transform 0.1s ease; }
        }

        

        @keyframes glow { 0%, 100% { box-shadow: 0 0 20px rgba(99, 102, 241, 0.3); } 50% { box-shadow: 0 0 30px rgba(99, 102, 241, 0.6); } }

        @keyframes pulse { 0%, 100% { transform: scale(1); } 50% { transform: scale(1.05); } }

        @keyframes slideIn { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

        

        .form-select, .form-input, .form-textarea {

            background-color: #374151; border-color: #4B5563; color: #F9FAFB;

            transition: all 0.3s ease;

            border-width: 2px;

        }

        .form-select:focus, .form-input:focus, .form-textarea:focus {

            --tw-ring-color: #4F46E5; border-color: #4F46E5;

            background-color: #4B5563;

            animation: glow 2s infinite;

        }

        

        input[type="color"] {

            -webkit-appearance: none; appearance: none; border: none; width: 50px; height: 50px; border-radius: 50%; cursor: pointer; background-color: transparent;

            transition: transform 0.2s ease;

        }

        input[type="color"]:hover { transform: scale(1.1); }

        input[type="color"]::-webkit-color-swatch-wrapper { padding: 0; }

        input[type="color"]::-webkit-color-swatch { border-radius: 50%; border: 3px solid #4B5563; }

        

        #website-preview {

            width: 100%; height: 100%; border: none; background-color: #fff;

            border-radius: 8px;

        }

        

        /* Enhanced button styles */

        .btn-awesome {

            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);

            position: relative;

            overflow: hidden;

            transition: all 0.3s ease;

        }

        .btn-awesome:hover {

            transform: translateY(-2px);

            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);

        }

        .btn-awesome:active { transform: translateY(0); }

        

        .btn-awesome::before {

            content: '';

            position: absolute;

            top: 0;

            left: -100%;

            width: 100%;

            height: 100%;

            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);

            transition: left 0.5s;

        }

        .btn-awesome:hover::before { left: 100%; }

        

        /* Card animations */

        .card-animate {

            animation: slideIn 0.6s ease-out;

        }

        

        /* Preview container enhancements */

        .preview-container {

            background: linear-gradient(145deg, #374151, #4B5563);

            box-shadow: 0 20px 40px rgba(0,0,0,0.3);

        }

        

        /* Gradient text */

        .gradient-text {

            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);

            -webkit-background-clip: text;

            -webkit-text-fill-color: transparent;

            background-clip: text;

            color: #667eea; /* Fallback color */

        }

        

        /* Fallback for browsers that don't support gradient text */

        @supports not (-webkit-background-clip: text) {

            .gradient-text {

                color: #667eea;

                background: none;

            }

        }

        

        /* Enhanced form styling */

        .form-group {

            position: relative;

        }

        .form-group label {

            transition: all 0.3s ease;

        }

        .form-group:focus-within label {

            color: #667eea;

            transform: translateY(-2px);

        }

    </style>

</head>

<body class="bg-gray-900 text-white antialiased">



<!-- Header with Navigation -->

<div class="container mx-auto p-4 sm:p-6 md:p-8">

    <header class="bg-slate-800 border-b border-slate-700 px-6 py-4 mb-8 rounded-lg">

        <div class="flex items-center justify-between">

            <div class="flex items-center gap-3">

                <button onclick="goBack()" class="flex items-center gap-2 bg-slate-700 hover:bg-slate-600 text-white px-4 py-2 rounded-lg transition-colors">

                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>

                    <span class="font-medium">Back</span>

                </button>

                <a href="../APP_USAGE_GUIDES/17_website_generator.html" class="flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg transition-colors">

                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>

                    <span class="font-medium">How to Guide</span>

                </a>

            </div>

            <div class="flex items-center gap-3">

                <a href="index.php" class="text-sm text-gray-400 hover:text-white transition-colors">

                    ← Return to Dashboard

                </a>

              

            </div>

        </div>

        <div class="text-center mt-6">

            <h1 class="text-4xl md:text-5xl font-bold text-cyan-400">

                Intelligent Site Generator

            </h1>

            <p class="text-gray-400 mt-2">Describe your business or hobby and generate a complete website wireframe</p>

        </div>

    </header>



    <!-- Main Content Grid -->



    <div id="message-box" class="mt-4 mb-6"></div>



    <div class="grid grid-cols-1 xl:grid-cols-3 gap-8">

        <!-- Left Column: Website Vision -->

        <div class="bg-gray-800 p-6 rounded-2xl shadow-lg border border-gray-700 flex flex-col space-y-6 card-animate">

            <div>

                <h2 class="text-2xl font-bold mb-4 gradient-text">🎨 Step 1: Describe Your Website Vision</h2>

                <div class="space-y-6">

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">

                        <div class="form-group">

                            <label for="business-name" class="block text-sm font-medium text-gray-300 mb-2">✨ Business Name</label>

                            <input type="text" id="business-name" class="w-full form-input rounded-lg p-3" placeholder="e.g., 'Starlight Cafe'">

                        </div>

                        <div class="form-group">

                            <label for="business-type" class="block text-sm font-medium text-gray-300 mb-2">🏢 Industry/Business Type</label>

                            <select id="business-type" class="w-full form-select rounded-lg p-3">

                                <optgroup label="Technology & Innovation">

                                    <option value="ai-ml">Artificial Intelligence & Machine Learning</option>

                                    <option value="software">Software Development</option>

                                    <option value="cybersecurity">Cybersecurity</option>

                                    <option value="cloud-computing">Cloud Computing</option>

                                    <option value="iot">Internet of Things (IoT)</option>

                                </optgroup>

                                <optgroup label="Science & Research">

                                    <option value="biotech">Biotechnology</option>

                                    <option value="space">Space & Astronomy</option>

                                    <option value="clean-energy">Clean Energy & Sustainability</option>

                                    <option value="medical-research">Medical Research</option>

                                    <option value="materials-science">Materials Science</option>

                                </optgroup>

                                <optgroup label="Retail & Commerce">

                                    <option value="fashion">Fashion & Apparel</option>

                                    <option value="electronics">Electronics</option>

                                    <option value="home-garden">Home & Garden</option>

                                    <option value="luxury">Luxury Goods</option>

                                    <option value="sports">Sports & Recreation</option>

                                </optgroup>

                                <optgroup label="Food & Hospitality">

                                    <option value="restaurant">Restaurant</option>

                                    <option value="cafe">Café & Coffee Shop</option>

                                    <option value="bakery">Bakery</option>

                                    <option value="hotel">Hotel & Lodging</option>

                                    <option value="catering">Catering Service</option>

                                </optgroup>

                                <optgroup label="Health & Wellness">

                                    <option value="healthcare">Healthcare Services</option>

                                    <option value="fitness">Fitness & Gym</option>

                                    <option value="spa">Spa & Wellness Center</option>

                                    <option value="mental-health">Mental Health Services</option>

                                    <option value="nutrition">Nutrition & Diet</option>

                                </optgroup>

                                <optgroup label="Professional Services">

                                    <option value="legal">Legal Services</option>

                                    <option value="consulting">Business Consulting</option>

                                    <option value="financial">Financial Services</option>

                                    <option value="real-estate">Real Estate</option>

                                    <option value="marketing">Marketing & Advertising</option>

                                </optgroup>

                                <optgroup label="Education & Learning">

                                    <option value="school">School & Academy</option>

                                    <option value="online-learning">Online Learning Platform</option>

                                    <option value="tutoring">Tutoring Services</option>

                                    <option value="skill-development">Skill Development</option>

                                    <option value="language">Language School</option>

                                </optgroup>

                                <optgroup label="Creative & Media">

                                    <option value="design-studio">Design Studio</option>

                                    <option value="photography">Photography</option>

                                    <option value="music">Music & Audio</option>

                                    <option value="film-production">Film & Video Production</option>

                                    <option value="art-gallery">Art Gallery</option>

                                </optgroup>

                                <optgroup label="Manufacturing & Industry">

                                    <option value="automotive">Automotive</option>

                                    <option value="aerospace">Aerospace</option>

                                    <option value="robotics">Robotics</option>

                                    <option value="construction">Construction</option>

                                    <option value="machinery">Industrial Machinery</option>

                                </optgroup>

                                <optgroup label="Environment & Sustainability">

                                    <option value="renewable-energy">Renewable Energy</option>

                                    <option value="recycling">Recycling & Waste Management</option>

                                    <option value="eco-products">Eco-Friendly Products</option>

                                    <option value="conservation">Environmental Conservation</option>

                                    <option value="sustainable-agriculture">Sustainable Agriculture</option>

                                </optgroup>

                            </select>

                        </div>

                    </div>

                    <div class="form-group">

                        <label for="key-features" class="block text-sm font-medium text-gray-300 mb-2">🚀 Wanted Features / Pages needed</label>

                        <textarea id="key-features" rows="4" class="w-full form-textarea rounded-lg p-3" placeholder="e.g., 'Homepage with hero section, Menu page with categories, Contact form with map, About us with team photos, Online ordering system'"></textarea>

                    </div>

                    

                    <div class="space-y-4 p-4 bg-gray-700/50 rounded-lg">

                        <h3 class="text-lg font-semibold text-gray-200"> 🎯Advanced Website Components</h3>

                        <p class="text-sm text-gray-400 mb-4">Select components to automatically add to your wanted features</p>

                        

                        <div class="space-y-6">

                            <!-- Hero Section Style -->

                            <div class="form-group">

                                <label class="block text-sm font-medium text-gray-300 mb-3">🌟 Hero Section Style</label>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="hero-style" value="gradient-hero" class="mr-2 text-blue-500" checked>

                                        <span class="text-sm">Elegant Gradient Hero (Soft color transitions with showcase)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="hero-style" value="video-hero" class="mr-2 text-blue-500">

                                        <span class="text-sm">Runway Video Hero (Dynamic collection display)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="hero-style" value="image-hero" class="mr-2 text-blue-500">

                                        <span class="text-sm">Boutique Showcase Hero (High-quality photography)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="hero-style" value="animated-hero" class="mr-2 text-blue-500">

                                        <span class="text-sm">Sparkle Animation Hero (Elegant particle effects)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="hero-style" value="split-hero" class="mr-2 text-blue-500">

                                        <span class="text-sm">Before/After Split Hero (Transformation showcase)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="hero-style" value="minimal-hero" class="mr-2 text-blue-500">

                                        <span class="text-sm">Classic Minimal Hero (Focus on single statement)</span>

                                    </label>

                                </div>

                            </div>



                            <!-- Navigation Style -->

                            <div class="form-group">

                                <label class="block text-sm font-medium text-gray-300 mb-3">🧭 Navigation Style</label>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="navigation-style" value="horizontal-nav" class="mr-2 text-blue-500" checked>

                                        <span class="text-sm">Elegant Horizontal Nav (Classic boutique menu)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="navigation-style" value="sticky-nav" class="mr-2 text-blue-500">

                                        <span class="text-sm"> Categories Nav (Stays visible while browsing)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="navigation-style" value="hamburger-nav" class="mr-2 text-blue-500">

                                        <span class="text-sm">Responsive Mobile Menu (Perfect for browsing on phones)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="navigation-style" value="sidebar-nav" class="mr-2 text-blue-500">

                                        <span class="text-sm">Collection Sidebar (Easy filtering)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="navigation-style" value="mega-menu" class="mr-2 text-blue-500">

                                        <span class="text-sm">Showcase Menu (With category previews)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="navigation-style" value="floating-nav" class="mr-2 text-blue-500">

                                        <span class="text-sm">Floating Boutique Nav (Elegant overlay menu)</span>

                                    </label>

                                </div>

                            </div>



                            <!-- Content Sections -->

                            <div class="form-group">

                                <label class="block text-sm font-medium text-gray-300 mb-3">📄 Content Sections (Multi-Select)</label>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="carousel" class="mr-2 text-blue-500">

                                        <span class="text-sm">Featured Collection Carousel (Showcase your best items)</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="testimonials" class="mr-2 text-blue-500">

                                        <span class="text-sm">Customer Stories & Reviews</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="pricing-table" class="mr-2 text-blue-500">

                                        <span class="text-sm">Product Price Categories & Packages</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="team-section" class="mr-2 text-blue-500">

                                        <span class="text-sm">Our Team & Staff Members</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="portfolio-gallery" class="mr-2 text-blue-500">

                                        <span class="text-sm">Project Portfolio Gallery</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="blog-preview" class="mr-2 text-blue-500">

                                        <span class="text-sm">Industry Tips & Trends Blog</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="stats-counter" class="mr-2 text-blue-500">

                                        <span class="text-sm">Achievement Milestones Counter</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="timeline" class="mr-2 text-blue-500">

                                        <span class="text-sm">Process Timeline Guide</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="faq-accordion" class="mr-2 text-blue-500">

                                        <span class="text-sm">Product & Services FAQ Guide</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="content-sections" value="feature-grid" class="mr-2 text-blue-500">

                                        <span class="text-sm">Product Features & Details Grid</span>

                                    </label>

                                </div>

                            </div>



                            <!-- Interactive Elements -->

                            <div class="form-group">

                                <label class="block text-sm font-medium text-gray-300 mb-3">⚡ Interactive Elements (Multi-Select)</label>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="contact-form" class="mr-2 text-blue-500">

                                        <span class="text-sm">Professional Consultation Request Form</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="newsletter-signup" class="mr-2 text-blue-500">

                                        <span class="text-sm">Newsletter & Updates Signup</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="search-bar" class="mr-2 text-blue-500">

                                        <span class="text-sm">Advanced Product & Service Search</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="live-chat" class="mr-2 text-blue-500">

                                        <span class="text-sm">Live Customer Support Chat</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="booking-system" class="mr-2 text-blue-500">

                                        <span class="text-sm">Appointment Scheduling System</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="shopping-cart" class="mr-2 text-blue-500">

                                        <span class="text-sm">Online Booking & Reservation System</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="user-login" class="mr-2 text-blue-500">

                                        <span class="text-sm">Customer Portal & Dashboard</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="social-feed" class="mr-2 text-blue-500">

                                        <span class="text-sm">Social Media Feed Integration</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="map-integration" class="mr-2 text-blue-500">

                                        <span class="text-sm">Business Location & Directions</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="interactive-elements" value="video-player" class="mr-2 text-blue-500">

                                        <span class="text-sm">Product & Service Video Showcase</span>

                                    </label>

                                </div>

                            </div>



                            <!-- Layout Style -->

                            <div class="form-group">

                                <label class="block text-sm font-medium text-gray-300 mb-3">🎨 Layout Style</label>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="layout-style" value="modern-cards" class="mr-2 text-blue-500" checked>

                                        <span class="text-sm">Modern Card Layout</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="layout-style" value="magazine-style" class="mr-2 text-blue-500">

                                        <span class="text-sm">Magazine Style Layout</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="layout-style" value="grid-masonry" class="mr-2 text-blue-500">

                                        <span class="text-sm">Masonry Grid Layout</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="layout-style" value="single-page" class="mr-2 text-blue-500">

                                        <span class="text-sm">Single Page Layout</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="layout-style" value="multi-page" class="mr-2 text-blue-500">

                                        <span class="text-sm">Multi-Page Layout</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="layout-style" value="dashboard-style" class="mr-2 text-blue-500">

                                        <span class="text-sm">Dashboard Style</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="radio" name="layout-style" value="landing-page" class="mr-2 text-blue-500">

                                        <span class="text-sm">Landing Page Focus</span>

                                    </label>

                                </div>

                            </div>



                            <!-- Advertisement Placements -->

                            <div class="form-group">

                                <label class="block text-sm font-medium text-gray-300 mb-3">💰 Advertisement Placements (Multi-Select)</label>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="header-banner" class="mr-2 text-blue-500">

                                        <span class="text-sm">Header Banner Ads</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="sidebar-ads" class="mr-2 text-blue-500">

                                        <span class="text-sm">Sidebar Advertisement</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="inline-content" class="mr-2 text-blue-500">

                                        <span class="text-sm">Inline Content Ads</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="footer-ads" class="mr-2 text-blue-500">

                                        <span class="text-sm">Footer Advertisement</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="popup-ads" class="mr-2 text-blue-500">

                                        <span class="text-sm">Popup/Modal Ads</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="sponsored-content" class="mr-2 text-blue-500">

                                        <span class="text-sm">Sponsored Content Sections</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="video-ads" class="mr-2 text-blue-500">

                                        <span class="text-sm">Video Advertisement</span>

                                    </label>

                                    <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                        <input type="checkbox" name="ad-placements" value="native-ads" class="mr-2 text-blue-500">

                                        <span class="text-sm">Native Advertisement</span>

                                    </label>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="space-y-4 p-4 bg-gray-700/50 rounded-lg">

                        <h3 class="text-lg font-semibold text-gray-200">🎨 Advanced Color Palette</h3>

                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">

                            <div class="form-group">

                                <label for="primary-color" class="block text-xs font-medium text-gray-300 mb-1">Primary Color</label>

                                <input type="color" id="primary-color" value="#6366F1" class="w-full h-10">

                            </div>

                            <div class="form-group">

                                <label for="secondary-color" class="block text-xs font-medium text-gray-300 mb-1">Secondary Color</label>

                                <input type="color" id="secondary-color" value="#10B981" class="w-full h-10">

                            </div>

                            <div class="form-group">

                                <label for="accent-color" class="block text-xs font-medium text-gray-300 mb-1">Accent Color</label>

                                <input type="color" id="accent-color" value="#F59E0B" class="w-full h-10">

                            </div>

                            <div class="form-group">

                                <label for="background-color" class="block text-xs font-medium text-gray-300 mb-1">Background Color</label>

                                <input type="color" id="background-color" value="#1F2937" class="w-full h-10">

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>



        <!-- Middle Column: Content You Like & Parts Section -->

        <div class="bg-gray-800 p-6 rounded-2xl shadow-lg border border-gray-700 flex flex-col space-y-6 card-animate">

            <!-- Content You Like Section -->

            <div>

                <h2 class="text-2xl font-bold mb-4 gradient-text">💡 Content You Like</h2>

                <p class="text-gray-400 text-sm mb-4">Add your own content, text, or ideas that you want to include in your website</p>

                

                <div class="space-y-4">

                    <div class="form-group">

                        <label for="custom-headline" class="block text-sm font-medium text-gray-300 mb-2">✨ Custom Headlines</label>

                        <textarea id="custom-headline" rows="2" class="w-full form-textarea rounded-lg p-3" placeholder="e.g., 'Welcome to the Future of Coffee' or 'Your Dream Home Awaits'"></textarea>

                    </div>

                    

                    <div class="form-group">

                        <label for="custom-content" class="block text-sm font-medium text-gray-300 mb-2">📝 Your Content & Text</label>

                        <textarea id="custom-content" rows="4" class="w-full form-textarea rounded-lg p-3" placeholder="Add any specific text, descriptions, or content you want to include in your website..."></textarea>

                    </div>

                    

                    <div class="form-group">

                        <label for="custom-images" class="block text-sm font-medium text-gray-300 mb-2">🖼️ Image Ideas & Descriptions</label>

                        <textarea id="custom-images" rows="3" class="w-full form-textarea rounded-lg p-3" placeholder="Describe images you want: 'Modern coffee shop interior', 'Team photo in casual setting', etc."></textarea>

                    </div>

                    

                    <div class="form-group">

                        <label for="brand-voice" class="block text-sm font-medium text-gray-300 mb-2">🎭 Brand Voice & Tone</label>

                        <select id="brand-voice" class="w-full form-select rounded-lg p-3">

                            <option value="professional">Professional & Corporate</option>

                            <option value="friendly">Friendly & Approachable</option>

                            <option value="creative">Creative & Artistic</option>

                            <option value="modern">Modern & Tech-Savvy</option>

                            <option value="luxury">Luxury & Premium</option>

                            <option value="casual">Casual & Relaxed</option>

                            <option value="energetic">Energetic & Dynamic</option>

                            <option value="trustworthy">Trustworthy & Reliable</option>

                        </select>

                    </div>

                </div>

            </div>



            <!-- Parts Section -->

            <div class="border-t border-gray-600 pt-6">

                <h2 class="text-2xl font-bold mb-4 gradient-text">🧩 Website Parts & Components</h2>

                <p class="text-gray-400 text-sm mb-4">Select and customize specific parts of your website</p>

                

                <div class="space-y-4">

                    <!-- Header/Navigation Parts -->

                    <div class="bg-gray-700/50 p-4 rounded-lg">

                        <h3 class="text-lg font-semibold text-gray-200 mb-3">🧭 Header & Navigation Parts</h3>

                        <div class="grid grid-cols-1 gap-2">

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="header-parts" value="logo-left" class="mr-2 text-blue-500">

                                <span class="text-sm">Logo on Left + Menu Right</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="header-parts" value="centered-logo" class="mr-2 text-blue-500">

                                <span class="text-sm">Centered Logo + Menu Below</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="header-parts" value="search-bar" class="mr-2 text-blue-500">

                                <span class="text-sm">Search Bar in Header</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="header-parts" value="contact-info" class="mr-2 text-blue-500">

                                <span class="text-sm">Contact Info in Header</span>

                            </label>

                        </div>

                    </div>



                    <!-- Content Parts -->

                    <div class="bg-gray-700/50 p-4 rounded-lg">

                        <h3 class="text-lg font-semibold text-gray-200 mb-3">📄 Content Parts</h3>

                        <div class="grid grid-cols-1 gap-2">

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="content-parts" value="hero-banner" class="mr-2 text-blue-500" checked>

                                <span class="text-sm">Hero Banner Section</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="content-parts" value="about-section" class="mr-2 text-blue-500" checked>

                                <span class="text-sm">About Us Section</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="content-parts" value="services-grid" class="mr-2 text-blue-500" checked>

                                <span class="text-sm">Services/Products Grid</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="content-parts" value="testimonials-slider" class="mr-2 text-blue-500">

                                <span class="text-sm">Testimonials Slider</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="content-parts" value="image-gallery" class="mr-2 text-blue-500">

                                <span class="text-sm">Image Gallery</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="content-parts" value="pricing-table" class="mr-2 text-blue-500">

                                <span class="text-sm">Pricing Table</span>

                            </label>

                        </div>

                    </div>



                    <!-- Footer Parts -->

                    <div class="bg-gray-700/50 p-4 rounded-lg">

                        <h3 class="text-lg font-semibold text-gray-200 mb-3">🦶 Footer Parts</h3>

                        <div class="grid grid-cols-1 gap-2">

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="footer-parts" value="contact-info" class="mr-2 text-blue-500" checked>

                                <span class="text-sm">Contact Information</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="footer-parts" value="social-links" class="mr-2 text-blue-500" checked>

                                <span class="text-sm">Social Media Links</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="footer-parts" value="newsletter" class="mr-2 text-blue-500">

                                <span class="text-sm">Newsletter Signup</span>

                            </label>

                            <label class="flex items-center p-2 bg-gray-600/50 rounded-lg hover:bg-gray-600 transition-colors cursor-pointer">

                                <input type="checkbox" name="footer-parts" value="quick-links" class="mr-2 text-blue-500">

                                <span class="text-sm">Quick Links Menu</span>

                            </label>

                        </div>

                    </div>

                </div>

            </div>

        </div>



        <!-- Right Column: Generate & Preview -->

        <div class="bg-gray-800 p-6 rounded-2xl shadow-lg border border-gray-700 flex flex-col space-y-6 card-animate">

            <div class="border-t border-gray-600 pt-6">

                <h2 class="text-2xl font-bold mb-4 gradient-text">⚡ Step 2: Generate & Refine</h2>

                <div class="space-y-4">

                    <div class="grid grid-cols-2 gap-4">

                        <button id="btn-generate-code" class="btn-awesome w-full flex items-center justify-center text-white font-bold py-4 px-6 rounded-lg shadow-lg disabled:opacity-50">

                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>

                            </svg>

                            Generate Awesome Website

                        </button>

                        <button id="btn-download-code" class="w-full flex items-center justify-center bg-gradient-to-r from-green-500 to-emerald-600 hover:from-green-600 hover:to-emerald-700 text-white font-bold py-4 px-6 rounded-lg shadow-lg transition-all duration-300 hover:scale-105 disabled:opacity-50" disabled>

                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>

                            </svg>

                            Download Site

                        </button>

                    </div>

                    

                    <!-- Multi-Page Download Section -->

                    <div id="multipage-downloads" class="hidden space-y-3 p-4 bg-gray-700/50 rounded-lg border border-gray-600">

                        <h3 class="text-lg font-semibold text-gray-200 mb-3">📄 Multi-Page Website Downloads</h3>

                        <div class="grid grid-cols-2 md:grid-cols-4 gap-3">

                            <button id="btn-download-page1" class="flex items-center justify-center bg-blue-600 hover:bg-blue-700 text-white font-medium py-3 px-4 rounded-lg transition-all duration-300 hover:scale-105 disabled:opacity-50" disabled>

                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>

                                </svg>

                                Page 1

                            </button>

                            <button id="btn-download-page2" class="flex items-center justify-center bg-purple-600 hover:bg-purple-700 text-white font-medium py-3 px-4 rounded-lg transition-all duration-300 hover:scale-105 disabled:opacity-50" disabled>

                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>

                                </svg>

                                Page 2

                            </button>

                            <button id="btn-download-page3" class="flex items-center justify-center bg-orange-600 hover:bg-orange-700 text-white font-medium py-3 px-4 rounded-lg transition-all duration-300 hover:scale-105 disabled:opacity-50" disabled>

                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>

                                </svg>

                                Page 3

                            </button>

                            <button id="btn-download-page4" class="flex items-center justify-center bg-red-600 hover:bg-red-700 text-white font-medium py-3 px-4 rounded-lg transition-all duration-300 hover:scale-105 disabled:opacity-50" disabled>

                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>

                                </svg>

                                Page 4

                            </button>

                        </div>

                        <div class="text-xs text-gray-400 mt-2">

                            <p>⏱️ Multi-page generation includes rate limiting for optimal quality</p>

                        </div>

                    </div>

                </div>

                 <div class="mt-6">

                    <label for="final-code" class="block text-sm font-medium text-gray-300 mb-2">💻 Generated HTML & CSS</label>

                    <textarea id="final-code" rows="8" class="w-full form-textarea rounded-lg p-3 font-mono text-sm" placeholder="Your awesome website code will appear here..."></textarea>

                </div>

            </div>

        </div>

    </div>



    <!-- Full Width Preview Section -->

    <div class="mt-8">

        <div id="preview-container" class="preview-container p-3 rounded-2xl flex flex-col card-animate">

            <div class="bg-gradient-to-r from-indigo-600 to-purple-600 p-4 rounded-t-lg">

                <div class="flex items-center justify-between">

                    <div class="text-white font-semibold">

                        🌟 Full Layout Preview - Your Website in Action

                    </div>

                    <div class="flex items-center space-x-2">

                        <button id="preview-desktop" class="bg-white/20 hover:bg-white/30 text-white px-3 py-1 rounded text-sm transition-colors">

                            🖥️ Desktop

                        </button>

                        <button id="preview-tablet" class="bg-white/20 hover:bg-white/30 text-white px-3 py-1 rounded text-sm transition-colors">

                            📱 Tablet

                        </button>

                        <button id="preview-mobile" class="bg-white/20 hover:bg-white/30 text-white px-3 py-1 rounded text-sm transition-colors">

                            📱 Mobile

                        </button>

                    </div>

                </div>

            </div>

            <div class="flex-grow bg-white rounded-b-lg overflow-hidden" style="min-height: 600px;">

                <iframe id="website-preview" title="Website Preview" style="width: 100%; height: 600px; border: none; transition: all 0.3s ease;"></iframe>

            </div>

        </div>

    </div>

</div>



<footer class="mt-12 py-8 bg-gray-800/50 backdrop-blur-sm border-t border-gray-700">

    <div class="container mx-auto px-4 sm:px-6 md:px-8">

        <div class="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">

            <div class="text-center md:text-left">

                <h3 class="text-lg font-bold gradient-text"><a href="https://ai-itinc.com/website-gen.php" >✨ Intelligent-Site Generator </a></h3>

                <p class="text-gray-400 text-sm mt-1">Create stunning websites with Business Intelligence-powered design</p>

            </div>

            <!--<nav class="flex items-center space-x-4">

                <a href="index.php" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition-all duration-300 hover:scale-105">

                    💬 Chat

                </a>

                <a href="agent-workspace.php" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded-lg transition-all duration-300 hover:scale-105">

                    🚀 Agent LaunchPad

                </a>

                <a href="i-want-it.php" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded-lg transition-all duration-300 hover:scale-105">

                    🎯 I Want IT!

                </a>

            </nav>-->

        </div>

        <div class="mt-6 pt-6 border-t border-gray-700 text-center text-gray-400 text-sm">

            <p>✨ Business Suite App by SC and LC</p>

        </div>

    </div>

</footer>

<script>

// Back button functionality

function goBack() {

    if (window.history.length > 1) {

        window.history.back();

    } else {

        window.location.href = 'index.php';

    }

}



document.addEventListener('DOMContentLoaded', () => {

    const businessNameEl = document.getElementById('business-name');

    const businessTypeEl = document.getElementById('business-type');

    const keyFeaturesEl = document.getElementById('key-features');

    const primaryColorEl = document.getElementById('primary-color');

    const generateCodeBtn = document.getElementById('btn-generate-code');

    const downloadCodeBtn = document.getElementById('btn-download-code');

    const finalCodeEl = document.getElementById('final-code');

    const previewFrame = document.getElementById('website-preview');

    const messageBox = document.getElementById('message-box');

    const logoutBtn = document.getElementById('logout-btn');



    let originalButtonText = {};

    

    // Multi-page storage

    let generatedPages = {

        page1: null,

        page2: null,

        page3: null,

        page4: null

    };

    

    // Rate limiting variables

    let isGeneratingMultiPage = false;

    const RATE_LIMIT_DELAY = 3000; // 3 seconds between page generations



    // Function to update wanted features based on selected components

    const updateWantedFeatures = () => {

        const selectedFeatures = [];

        

        // Get selected hero style

        const heroStyle = document.querySelector('input[name="hero-style"]:checked');

        if (heroStyle) {

            selectedFeatures.push(`${heroStyle.nextElementSibling.textContent}`);

        }

        

        // Get selected navigation style

        const navStyle = document.querySelector('input[name="navigation-style"]:checked');

        if (navStyle) {

            selectedFeatures.push(`${navStyle.nextElementSibling.textContent}`);

        }

        

        // Get selected layout style

        const layoutStyle = document.querySelector('input[name="layout-style"]:checked');

        if (layoutStyle) {

            selectedFeatures.push(`${layoutStyle.nextElementSibling.textContent}`);

        }

        

        // Get selected content sections

        const contentSections = document.querySelectorAll('input[name="content-sections"]:checked');

        contentSections.forEach(section => {

            selectedFeatures.push(`${section.nextElementSibling.textContent}`);

        });

        

        // Get selected interactive elements

        const interactiveElements = document.querySelectorAll('input[name="interactive-elements"]:checked');

        interactiveElements.forEach(element => {

            selectedFeatures.push(`${element.nextElementSibling.textContent}`);

        });

        

        // Get selected ad placements

        const adPlacements = document.querySelectorAll('input[name="ad-placements"]:checked');

        adPlacements.forEach(ad => {

            selectedFeatures.push(`${ad.nextElementSibling.textContent}`);

        });

        

        // Update the wanted features textarea

        const currentFeatures = keyFeaturesEl.value.trim();

        const baseFeatures = currentFeatures.split('\n').filter(line => 

            line.trim() && 

            !line.includes('Hero') && 

            !line.includes('Navigation') && 

            !line.includes('Layout') && 

            !line.includes('Carousel') && 

            !line.includes('Testimonials') && 

            !line.includes('Pricing') && 

            !line.includes('Team') && 

            !line.includes('Portfolio') && 

            !line.includes('Blog') && 

            !line.includes('Statistics') && 

            !line.includes('Timeline') && 

            !line.includes('FAQ') && 

            !line.includes('Feature Grid') && 

            !line.includes('Contact Form') && 

            !line.includes('Newsletter') && 

            !line.includes('Search') && 

            !line.includes('Chat') && 

            !line.includes('Booking') && 

            !line.includes('Shopping') && 

            !line.includes('Login') && 

            !line.includes('Social') && 

            !line.includes('Maps') && 

            !line.includes('Video') && 

            !line.includes('Banner') && 

            !line.includes('Sidebar') && 

            !line.includes('Inline') && 

            !line.includes('Footer') && 

            !line.includes('Popup') && 

            !line.includes('Sponsored') && 

            !line.includes('Native')

        );

        

        const allFeatures = [...baseFeatures, ...selectedFeatures].filter(Boolean);

        keyFeaturesEl.value = allFeatures.join(', ');

    };



    // Add event listeners to all component selection inputs

    document.querySelectorAll('input[name="hero-style"], input[name="navigation-style"], input[name="layout-style"], input[name="content-sections"], input[name="interactive-elements"], input[name="ad-placements"]').forEach(input => {

        input.addEventListener('change', updateWantedFeatures);

    });



    // Initialize with default selections

    updateWantedFeatures();



    const showMessage = (message, type = 'info') => {

        const colorClass = type === 'error' ? 'bg-red-900/50 text-red-300 border-red-700' : 'bg-blue-900/50 text-blue-300 border-blue-700';

        messageBox.innerHTML = `<div class="p-4 rounded-lg border ${colorClass}">${message}</div>`;

    };



    const setLoadingState = (button, isLoading, text = '') => {

        if (isLoading) {

            originalButtonText[button.id] = button.innerHTML;

            button.disabled = true;

            button.innerHTML = `<div class="spinner inline-block mr-2"></div> ${text}`;

        } else {

            button.disabled = false;

            button.innerHTML = originalButtonText[button.id] || 'Action';

        }

    };



    const callGateway = async (payload) => {

        try {

            const response = await fetch('../api/gateway.php?endpoint=chat', {

                method: 'POST',

                headers: { 'Content-Type': 'application/json' },

                credentials: 'include',

                body: JSON.stringify(payload)

            });

            

            if (!response.ok) {

                if (response.status === 401) {

                    window.location.reload();

                    return null;

                }

                

                let errorResult;

                try {

                    const responseText = await response.text();

                    errorResult = JSON.parse(responseText);

                } catch (parseError) {

                    console.error('Failed to parse error response:', parseError);

                    errorResult = { error: `API Error: ${response.status} - ${response.statusText}` };

                }

                

                throw new Error(errorResult.error || `API Error: ${response.status}`);

            }

            

            const responseText = await response.text();

            if (!responseText.trim()) {

                throw new Error('Empty response from server');

            }

            

            try {

                return JSON.parse(responseText);

            } catch (parseError) {

                console.error('Failed to parse JSON response:', responseText);

                throw new Error('Invalid JSON response from server');

            }

        } catch (error) {

            console.error('Gateway call failed:', error);

            showMessage(error.message, 'error');

            return null;

        }

    };



    if (logoutBtn) {

        logoutBtn.addEventListener('click', async () => {

            await fetch('auth.php', { method: 'POST', body: new URLSearchParams('action=logout') });

            window.location.href = 'index.php';

        });

    }



    generateCodeBtn.addEventListener('click', async () => {

        const businessName = businessNameEl.value.trim();

        const businessType = businessTypeEl.value.trim();

        const keyFeatures = keyFeaturesEl.value.trim();



        // Get "Content You Like" section values

        const customHeadline = document.getElementById('custom-headline').value.trim();

        const customContent = document.getElementById('custom-content').value.trim();

        const customImages = document.getElementById('custom-images').value.trim();

        const brandVoice = document.getElementById('brand-voice').value;



        // Get "Parts Section" values

        const headerParts = Array.from(document.querySelectorAll('input[name="header-parts"]:checked')).map(input => input.value);

        const contentParts = Array.from(document.querySelectorAll('input[name="content-parts"]:checked')).map(input => input.value);

        const footerParts = Array.from(document.querySelectorAll('input[name="footer-parts"]:checked')).map(input => input.value);



        // Get advanced options

        const secondaryColor = document.getElementById('secondary-color').value;

        const accentColor = document.getElementById('accent-color').value;

        const backgroundColor = document.getElementById('background-color').value;

        

        // Get selected radio button values

        const heroStyle = document.querySelector('input[name="hero-style"]:checked')?.value || 'gradient-hero';

        const navigationStyle = document.querySelector('input[name="navigation-style"]:checked')?.value || 'horizontal-nav';

        const layoutStyle = document.querySelector('input[name="layout-style"]:checked')?.value || 'modern-cards';

        

        // Get selected checkbox values

        const contentSections = Array.from(document.querySelectorAll('input[name="content-sections"]:checked')).map(input => input.value);

        const interactiveElements = Array.from(document.querySelectorAll('input[name="interactive-elements"]:checked')).map(input => input.value);

        const adPlacements = Array.from(document.querySelectorAll('input[name="ad-placements"]:checked')).map(input => input.value);



        if (!businessName || !businessType || !keyFeatures) {

            showMessage('Please fill out all fields to generate the website.', 'error');

            return;

        }

        setLoadingState(generateCodeBtn, true, 'Generating Website...');

        downloadCodeBtn.disabled = true;

        finalCodeEl.value = "🤖 Parallel Agent Workflow Starting...\n\nStep 1: Content Generator Agent is creating compelling text content...\nStep 2: Structure Generator Agent will build the website with the content...";

        previewFrame.srcdoc = `<div style="display:flex;justify-content:center;align-items:center;height:100%;font-family:sans-serif;color:#555;flex-direction:column;"><div style="font-size:24px;margin-bottom:20px;">🤖 Parallel Agent Workflow</div><div>Content Generator → Structure Generator</div></div>`;



        try {

            // STEP 1: Content Generator Agent (Llama-3.3-70B)

            showMessage('🤖 Step 1: Content Generator Agent is creating compelling content...', 'info');

            finalCodeEl.value = "🤖 Content Generator Agent (Llama-3.3-70B) is working...\n\nGenerating compelling text content for your website...";

            

            const contentPrompt = `You are a Content Generator Agent. Create compelling, professional content for a website.



Business Details:

- Name: "${businessName}"

- Type: "${businessType}"

- Features: "${keyFeatures}"



User's Custom Content Preferences:

- Custom Headlines: "${customHeadline || 'Use creative headlines'}"

- Custom Content: "${customContent || 'Create engaging content'}"

- Image Ideas: "${customImages || 'Use relevant business images'}"

- Brand Voice: "${brandVoice}" (Use this tone throughout all content)



User's Selected Website Parts:

- Header Parts: ${headerParts.length > 0 ? headerParts.join(', ') : 'Standard header'}

- Content Parts: ${contentParts.length > 0 ? contentParts.join(', ') : 'Standard content sections'}

- Footer Parts: ${footerParts.length > 0 ? footerParts.join(', ') : 'Standard footer'}



Generate content that incorporates the user's preferences and matches their selected brand voice (${brandVoice}). Use their custom headlines and content where provided, and create content that fits their selected website parts.



Generate the following content in JSON format:

{

  "heroTitle": "${customHeadline ? `Use this headline: ${customHeadline}` : 'Main headline for hero section'}",

  "heroSubtitle": "Compelling subtitle/description in ${brandVoice} tone",

  "heroCallToAction": "Call to action button text",

  "aboutTitle": "About section title",

  "aboutContent": "${customContent ? `Incorporate this content: ${customContent}` : `2-3 sentences about the business in ${brandVoice} tone`}",

  "servicesTitle": "Services/Features section title",

  "services": [

    {"title": "Service 1", "description": "Brief description in ${brandVoice} tone"},

    {"title": "Service 2", "description": "Brief description in ${brandVoice} tone"},

    {"title": "Service 3", "description": "Brief description in ${brandVoice} tone"}

  ],

  "contactTitle": "Contact section title",

  "contactDescription": "Brief contact description in ${brandVoice} tone",

  "footerText": "Footer tagline in ${brandVoice} tone",

  "imageDescriptions": "${customImages ? `Use these image ideas: ${customImages}` : 'Relevant business images'}"

}



OUTPUT: Only valid JSON, no explanations or markdown.`;



            const contentPayload = {

                model: 'together/meta-llama/Llama-3.3-70B-Instruct-Turbo-Free',

                messages: [{ role: 'user', content: contentPrompt }],

                max_tokens: 2048

            };



            const contentResult = await callGateway(contentPayload);

            

            if (!contentResult || !contentResult.choices || !contentResult.choices[0].message) {

                throw new Error('Content Generator Agent failed to respond');

            }



            let contentData;

            try {

                const contentText = contentResult.choices[0].message.content.trim();

                // Clean up any markdown formatting

                const cleanContent = contentText.replace(/^```json\n/, '').replace(/\n```$/, '');

                contentData = JSON.parse(cleanContent);

            } catch (e) {

                throw new Error('Content Generator Agent returned invalid JSON');

            }



            // STEP 2: Structure Generator Agent (DeepSeek-R1)

            showMessage('🤖 Step 2: Structure Generator Agent is building the website structure...', 'info');

            finalCodeEl.value = "🤖 Structure Generator Agent (DeepSeek-R1) is working...\n\nBuilding stunning website structure with the generated content...";



            const structurePrompt = `You are a Structure Generator Agent. Create a complete, stunning website template with all content filled in.



CONTENT TO USE:

- Hero Title: "${contentData.heroTitle}"

- Hero Subtitle: "${contentData.heroSubtitle}"

- Hero Call to Action: "${contentData.heroCallToAction}"

- About Title: "${contentData.aboutTitle}"

- About Content: "${contentData.aboutContent}"

- Services Title: "${contentData.servicesTitle}"

- Services: ${contentData.services.map(s => `"${s.title}: ${s.description}"`).join(', ')}

- Contact Title: "${contentData.contactTitle}"

- Contact Description: "${contentData.contactDescription}"

- Footer Text: "${contentData.footerText}"

- Image Descriptions: "${contentData.imageDescriptions || 'Relevant business images'}"



USER'S CUSTOM PREFERENCES:

- Brand Voice: ${brandVoice} (maintain this tone throughout)

- Custom Headlines: ${customHeadline ? `"${customHeadline}"` : 'Use generated headlines'}

- Custom Content: ${customContent ? `"${customContent}"` : 'Use generated content'}

- Image Ideas: ${customImages ? `"${customImages}"` : 'Use relevant business images'}



WEBSITE PARTS TO IMPLEMENT:

- Header Parts: ${headerParts.length > 0 ? headerParts.join(', ') : 'Standard header layout'}

- Content Parts: ${contentParts.length > 0 ? contentParts.join(', ') : 'Standard content sections'}

- Footer Parts: ${footerParts.length > 0 ? footerParts.join(', ') : 'Standard footer'}



ADVANCED DESIGN SPECIFICATIONS:

- Use Tailwind CSS CDN for styling

- Color Palette: Primary ${primaryColorEl.value}, Secondary ${secondaryColor}, Accent ${accentColor}, Background ${backgroundColor}

- Hero Style: ${heroStyle} (implement this specific hero style)

- Navigation: ${navigationStyle} (implement this navigation type)

- Layout Style: ${layoutStyle} (follow this layout approach)

- Brand Voice: Ensure all text matches the ${brandVoice} tone



REQUIRED CONTENT SECTIONS:

${contentSections.length > 0 ? `- Include these sections: ${contentSections.join(', ')}` : '- Standard sections: hero, about, services, contact'}



INTERACTIVE ELEMENTS TO INCLUDE:

${interactiveElements.length > 0 ? `- Add these interactive features: ${interactiveElements.join(', ')}` : '- Basic contact form and navigation'}



ADVERTISEMENT PLACEMENTS:

${adPlacements.length > 0 ? `- Include ad spaces: ${adPlacements.join(', ')} (create placeholder ad areas with proper styling)` : '- No advertisements'}



SPECIFIC IMPLEMENTATION REQUIREMENTS:

- Hero Section: Implement ${heroStyle} with stunning visual effects

- Navigation: Create ${navigationStyle} with smooth interactions

- Layout: Follow ${layoutStyle} design principles

- Color Scheme: Use the 4-color palette throughout the design

- Responsive Design: Ensure perfect mobile, tablet, and desktop layouts

- Modern UI: Include hover effects, transitions, animations, and micro-interactions

- Typography: Use modern font combinations with proper hierarchy

- Interactive Elements: Make all specified interactive features functional

- Content Sections: If carousel selected, include working image carousel with navigation

- Advertisement Areas: Style ad placeholders professionally if specified



ADVANCED FEATURES:

- Add CSS animations and transitions for smooth user experience

- Include modern gradients using the specified color palette

- Implement card-based layouts with shadows and hover effects

- Add loading animations and smooth scrolling

- Include modern icons (SVG or emoji)

- Create visually appealing call-to-action buttons

- Add professional spacing and typography hierarchy

- Include social media integration areas

- Implement modern form styling with validation states



NEGATIVE PROMPTS (DO NOT INCLUDE):

- No thinking process or explanations

- No placeholder text like "Hero Title" or "{{ heroTitle }}"

- No incomplete sections or missing content

- No markdown formatting or code blocks

- No comments or explanations in the code



STRUCTURE REQUIREMENTS:

1. Complete HTML document with head and body

2. Hero section with actual content filled in using specified hero style

3. About section with actual content filled in

4. Services section with all services listed

5. All selected content sections implemented

6. All selected interactive elements functional

7. Contact section with form and actual content

8. Footer with actual footer text and links

9. Advertisement areas if specified

10. All content must be the actual generated content, not placeholders



OUTPUT: Complete HTML document starting with <!DOCTYPE html> and ending with </html>. Use ONLY the actual content provided above. NO placeholders, NO thinking, NO explanations.`;



            const structurePayload = {

                model: 'together/deepseek-ai/DeepSeek-R1-Distill-Llama-70B-free',

                messages: [{ role: 'user', content: structurePrompt }],

                max_tokens: 4096

            };



            const structureResult = await callGateway(structurePayload);

            setLoadingState(generateCodeBtn, false);



            if (structureResult && structureResult.choices && structureResult.choices[0].message) {

                let generatedCode = structureResult.choices[0].message.content.trim();

                

                // Clean up any markdown formatting or explanations

                generatedCode = generatedCode.replace(/^```html\n/, '').replace(/\n```$/, '');

                generatedCode = generatedCode.replace(/^```\n/, '').replace(/\n```$/, '');

                

                // Extract only the HTML document if there are explanations

                const htmlStart = generatedCode.indexOf('<!DOCTYPE html>');

                const htmlEnd = generatedCode.lastIndexOf('</html>') + 7;

                

                if (htmlStart !== -1 && htmlEnd !== -1) {

                    generatedCode = generatedCode.substring(htmlStart, htmlEnd);

                }

                

                // Remove any text before DOCTYPE or after closing html tag

                generatedCode = generatedCode.replace(/^[^<]*<!DOCTYPE/, '<!DOCTYPE');

                generatedCode = generatedCode.replace(/<\/html>[^<]*$/, '</html>');

                

                // Ensure we have a complete HTML document

                if (!generatedCode.startsWith('<!DOCTYPE html>')) {

                    throw new Error('Structure Generator did not produce valid HTML document');

                }

                

                finalCodeEl.value = generatedCode;

                previewFrame.srcdoc = generatedCode;

                downloadCodeBtn.disabled = false;

                showMessage('🎉 Parallel Agent Workflow completed! Website generated successfully with dual AI models.', 'info');

            } else {

                throw new Error('Structure Generator Agent failed to create website');

            }



        } catch (error) {

            setLoadingState(generateCodeBtn, false);

            showMessage(`❌ Parallel Agent Workflow failed: ${error.message}`, 'error');

            finalCodeEl.value = `Parallel Agent Workflow failed: ${error.message}\n\nPlease try again.`;

            previewFrame.srcdoc = `<div style="display:flex;justify-content:center;align-items:center;height:100%;font-family:sans-serif;color:red;">Workflow Failed: ${error.message}</div>`;

        }

    });



    downloadCodeBtn.addEventListener('click', () => {

        const codeToDownload = finalCodeEl.value;

        if (!codeToDownload) {

            showMessage('There is no code to download.', 'error');

            return;

        }

        const blob = new Blob([codeToDownload], { type: 'text/html' });

        const url = URL.createObjectURL(blob);

        const a = document.createElement('a');

        a.href = url;

        a.download = 'index.html';

        document.body.appendChild(a);

        a.click();

        document.body.removeChild(a);

        URL.revokeObjectURL(url);

    });



    // Multi-page generation function with rate limiting

    const generateMultiPageSite = async () => {

        if (isGeneratingMultiPage) {

            showMessage('Multi-page generation already in progress. Please wait...', 'error');

            return;

        }



        const businessName = businessNameEl.value.trim();

        const businessType = businessTypeEl.value.trim();

        const keyFeatures = keyFeaturesEl.value.trim();



        if (!businessName || !businessType || !keyFeatures) {

            showMessage('Please fill out all fields before generating multi-page site.', 'error');

            return;

        }



        isGeneratingMultiPage = true;

        

        // Show multi-page download section

        document.getElementById('multipage-downloads').classList.remove('hidden');

        

        // Disable all page download buttons initially

        ['btn-download-page1', 'btn-download-page2', 'btn-download-page3', 'btn-download-page4'].forEach(id => {

            document.getElementById(id).disabled = true;

        });



        const pageTypes = [

            { name: 'Homepage', description: 'Main landing page with hero section, overview, and key features' },

            { name: 'About/Services', description: 'Detailed about us page with services, team information, and company story' },

            { name: 'Contact/Location', description: 'Contact form, location map, business hours, and contact information' },

            { name: 'Portfolio/Gallery', description: 'Showcase page with portfolio items, gallery, testimonials, and case studies' }

        ];



        try {

            showMessage('🚀 Starting multi-page website generation with rate limiting...', 'info');

            

            for (let i = 0; i < pageTypes.length; i++) {

                const pageInfo = pageTypes[i];

                const pageNumber = i + 1;

                

                showMessage(`🤖 Generating Page ${pageNumber}: ${pageInfo.name} (${i + 1}/4)`, 'info');

                

                // Get advanced options for each page

                const secondaryColor = document.getElementById('secondary-color').value;

                const accentColor = document.getElementById('accent-color').value;

                const backgroundColor = document.getElementById('background-color').value;

                

                const heroStyle = document.querySelector('input[name="hero-style"]:checked')?.value || 'gradient-hero';

                const navigationStyle = document.querySelector('input[name="navigation-style"]:checked')?.value || 'horizontal-nav';

                const layoutStyle = document.querySelector('input[name="layout-style"]:checked')?.value || 'modern-cards';

                

                const contentSections = Array.from(document.querySelectorAll('input[name="content-sections"]:checked')).map(input => input.value);

                const interactiveElements = Array.from(document.querySelectorAll('input[name="interactive-elements"]:checked')).map(input => input.value);

                const adPlacements = Array.from(document.querySelectorAll('input[name="ad-placements"]:checked')).map(input => input.value);



                // Step 1: Content Generator for this specific page

                const contentPrompt = `You are a Content Generator Agent. Create compelling, professional content for a ${pageInfo.name} page.



Business Details:

- Name: "${businessName}"

- Type: "${businessType}"

- Features: "${keyFeatures}"

- Page Type: ${pageInfo.name}

- Page Purpose: ${pageInfo.description}



Generate content specifically for this ${pageInfo.name} page in JSON format:

{

  "pageTitle": "Page title for ${pageInfo.name}",

  "heroTitle": "Main headline specific to ${pageInfo.name}",

  "heroSubtitle": "Compelling subtitle for ${pageInfo.name}",

  "heroCallToAction": "Call to action button text",

  "mainContent": "2-3 paragraphs of content specific to ${pageInfo.name}",

  "sections": [

    {"title": "Section 1 Title", "content": "Section 1 content relevant to ${pageInfo.name}"},

    {"title": "Section 2 Title", "content": "Section 2 content relevant to ${pageInfo.name}"},

    {"title": "Section 3 Title", "content": "Section 3 content relevant to ${pageInfo.name}"}

  ],

  "callToActionTitle": "Final CTA section title",

  "callToActionText": "Final call to action text",

  "footerText": "Footer tagline for ${pageInfo.name}"

}



OUTPUT: Only valid JSON, no explanations or markdown.`;



                const contentPayload = {

                    model: 'together/meta-llama/Llama-3.3-70B-Instruct-Turbo-Free',

                    messages: [{ role: 'user', content: contentPrompt }],

                    max_tokens: 2048

                };



                const contentResult = await callGateway(contentPayload);

                

                if (!contentResult || !contentResult.choices || !contentResult.choices[0].message) {

                    throw new Error(`Content Generator failed for Page ${pageNumber}`);

                }



                let contentData;

                try {

                    const contentText = contentResult.choices[0].message.content.trim();

                    const cleanContent = contentText.replace(/^```json\n/, '').replace(/\n```$/, '');

                    contentData = JSON.parse(cleanContent);

                } catch (e) {

                    throw new Error(`Content Generator returned invalid JSON for Page ${pageNumber}`);

                }



                // Rate limiting delay before structure generation

                if (i > 0) {

                    showMessage(`⏱️ Rate limiting: Waiting ${RATE_LIMIT_DELAY/1000} seconds before generating Page ${pageNumber} structure...`, 'info');

                    await new Promise(resolve => setTimeout(resolve, RATE_LIMIT_DELAY));

                }



                // Step 2: Structure Generator for this specific page

                const structurePrompt = `You are a Structure Generator Agent. Create a complete, stunning ${pageInfo.name} page with all content filled in.



PAGE TYPE: ${pageInfo.name}

PAGE PURPOSE: ${pageInfo.description}



CONTENT TO USE:

- Page Title: "${contentData.pageTitle}"

- Hero Title: "${contentData.heroTitle}"

- Hero Subtitle: "${contentData.heroSubtitle}"

- Hero Call to Action: "${contentData.heroCallToAction}"

- Main Content: "${contentData.mainContent}"

- Sections: ${contentData.sections.map(s => `"${s.title}: ${s.content}"`).join(', ')}

- Call to Action Title: "${contentData.callToActionTitle}"

- Call to Action Text: "${contentData.callToActionText}"

- Footer Text: "${contentData.footerText}"



ADVANCED DESIGN SPECIFICATIONS:

- Use Tailwind CSS CDN for styling

- Color Palette: Primary ${primaryColorEl.value}, Secondary ${secondaryColor}, Accent ${accentColor}, Background ${backgroundColor}

- Hero Style: ${heroStyle} (implement this specific hero style)

- Navigation: ${navigationStyle} with links to other pages (Home, About, Contact, Portfolio)

- Layout Style: ${layoutStyle} (follow this layout approach)



REQUIRED CONTENT SECTIONS FOR ${pageInfo.name}:

${contentSections.length > 0 ? `- Include these sections: ${contentSections.join(', ')}` : '- Standard sections appropriate for ' + pageInfo.name}



INTERACTIVE ELEMENTS TO INCLUDE:

${interactiveElements.length > 0 ? `- Add these interactive features: ${interactiveElements.join(', ')}` : '- Basic navigation and page-appropriate interactions'}



ADVERTISEMENT PLACEMENTS:

${adPlacements.length > 0 ? `- Include ad spaces: ${adPlacements.join(', ')} (create placeholder ad areas with proper styling)` : '- No advertisements'}



SPECIFIC REQUIREMENTS FOR ${pageInfo.name}:

- Create a complete HTML page optimized for ${pageInfo.name}

- Include navigation menu with links to: Home (index.html), About (about.html), Contact (contact.html), Portfolio (portfolio.html)

- Make the current page (${pageInfo.name}) active in navigation

- Use all the provided content, no placeholders

- Implement responsive design for all devices

- Add modern animations and hover effects

- Include proper meta tags and page title

- Make it a standalone, complete webpage



OUTPUT: Complete HTML document starting with <!DOCTYPE html> and ending with </html>. Use ONLY the actual content provided above. NO placeholders, NO thinking, NO explanations.`;



                const structurePayload = {

                    model: 'together/deepseek-ai/DeepSeek-R1-Distill-Llama-70B-free',

                    messages: [{ role: 'user', content: structurePrompt }],

                    max_tokens: 4096

                };



                const structureResult = await callGateway(structurePayload);



                if (structureResult && structureResult.choices && structureResult.choices[0].message) {

                    let generatedCode = structureResult.choices[0].message.content.trim();

                    

                    // Clean up the generated code

                    generatedCode = generatedCode.replace(/^```html\n/, '').replace(/\n```$/, '');

                    generatedCode = generatedCode.replace(/^```\n/, '').replace(/\n```$/, '');

                    

                    const htmlStart = generatedCode.indexOf('<!DOCTYPE html>');

                    const htmlEnd = generatedCode.lastIndexOf('</html>') + 7;

                    

                    if (htmlStart !== -1 && htmlEnd !== -1) {

                        generatedCode = generatedCode.substring(htmlStart, htmlEnd);

                    }

                    

                    generatedCode = generatedCode.replace(/^[^<]*<!DOCTYPE/, '<!DOCTYPE');

                    generatedCode = generatedCode.replace(/<\/html>[^<]*$/, '</html>');

                    

                    if (!generatedCode.startsWith('<!DOCTYPE html>')) {

                        throw new Error(`Structure Generator did not produce valid HTML for Page ${pageNumber}`);

                    }

                    

                    // Store the generated page

                    generatedPages[`page${pageNumber}`] = generatedCode;

                    

                    // Enable the download button for this page

                    const downloadBtn = document.getElementById(`btn-download-page${pageNumber}`);

                    downloadBtn.disabled = false;

                    downloadBtn.classList.add('animate-pulse');

                    

                    showMessage(`✅ Page ${pageNumber}: ${pageInfo.name} generated successfully!`, 'info');

                    

                    // Update preview with the latest generated page

                    previewFrame.srcdoc = generatedCode;

                    finalCodeEl.value = `Multi-Page Site Generated!\n\nPage ${pageNumber} (${pageInfo.name}) - Latest Generated:\n\n${generatedCode.substring(0, 500)}...`;

                    

                } else {

                    throw new Error(`Structure Generator failed for Page ${pageNumber}`);

                }



                // Rate limiting delay between pages (except for the last page)

                if (i < pageTypes.length - 1) {

                    showMessage(`⏱️ Rate limiting: Waiting ${RATE_LIMIT_DELAY/1000} seconds before next page...`, 'info');

                    await new Promise(resolve => setTimeout(resolve, RATE_LIMIT_DELAY));

                }

            }



            showMessage('🎉 Multi-page website generation completed! All 4 pages are ready for download.', 'info');

            

        } catch (error) {

            showMessage(`❌ Multi-page generation failed: ${error.message}`, 'error');

        } finally {

            isGeneratingMultiPage = false;

        }

    };



    // Individual page download handlers

    ['page1', 'page2', 'page3', 'page4'].forEach((pageKey, index) => {

        const pageNumber = index + 1;

        const downloadBtn = document.getElementById(`btn-download-${pageKey}`);

        

        downloadBtn.addEventListener('click', () => {

            const pageCode = generatedPages[pageKey];

            if (!pageCode) {

                showMessage(`Page ${pageNumber} has not been generated yet. Please generate the multi-page site first.`, 'error');

                return;

            }

            

            const pageNames = ['homepage', 'about', 'contact', 'portfolio'];

            const fileName = `${pageNames[index]}.html`;

            

            const blob = new Blob([pageCode], { type: 'text/html' });

            const url = URL.createObjectURL(blob);

            const a = document.createElement('a');

            a.href = url;

            a.download = fileName;

            document.body.appendChild(a);

            a.click();

            document.body.removeChild(a);

            URL.revokeObjectURL(url);

            

            showMessage(`📄 ${fileName} downloaded successfully!`, 'info');

        });

    });



    // Add multi-page generation trigger when layout style is multi-page

    document.querySelectorAll('input[name="layout-style"]').forEach(input => {

        input.addEventListener('change', () => {

            if (input.value === 'multi-page' && input.checked) {

                // Auto-trigger multi-page generation when multi-page layout is selected

                setTimeout(() => {

                    if (businessNameEl.value.trim() && businessTypeEl.value.trim() && keyFeaturesEl.value.trim()) {

                        generateMultiPageSite();

                    }

                }, 500);

            }

        });

    });



    // Preview responsiveness controls

    const previewDesktopBtn = document.getElementById('preview-desktop');

    const previewTabletBtn = document.getElementById('preview-tablet');

    const previewMobileBtn = document.getElementById('preview-mobile');



    // Function to update preview size

    const updatePreviewSize = (size) => {

        const iframe = document.getElementById('website-preview');

        const container = iframe.parentElement;

        

        // Remove active state from all buttons

        [previewDesktopBtn, previewTabletBtn, previewMobileBtn].forEach(btn => {

            btn.classList.remove('bg-white/30');

            btn.classList.add('bg-white/20');

        });



        switch(size) {

            case 'desktop':

                iframe.style.width = '100%';

                iframe.style.height = '600px';

                iframe.style.maxWidth = 'none';

                iframe.style.margin = '0';

                previewDesktopBtn.classList.remove('bg-white/20');

                previewDesktopBtn.classList.add('bg-white/30');

                break;

            case 'tablet':

                iframe.style.width = '768px';

                iframe.style.height = '600px';

                iframe.style.maxWidth = '100%';

                iframe.style.margin = '0 auto';

                previewTabletBtn.classList.remove('bg-white/20');

                previewTabletBtn.classList.add('bg-white/30');

                break;

            case 'mobile':

                iframe.style.width = '375px';

                iframe.style.height = '600px';

                iframe.style.maxWidth = '100%';

                iframe.style.margin = '0 auto';

                previewMobileBtn.classList.remove('bg-white/20');

                previewMobileBtn.classList.add('bg-white/30');

                break;

        }

    };



    // Add event listeners for preview controls

    previewDesktopBtn.addEventListener('click', () => updatePreviewSize('desktop'));

    previewTabletBtn.addEventListener('click', () => updatePreviewSize('tablet'));

    previewMobileBtn.addEventListener('click', () => updatePreviewSize('mobile'));



    // Set default preview size

    updatePreviewSize('desktop');



    // Update wanted features when parts are selected

    const updateWantedFeaturesFromParts = () => {

        const selectedParts = [];

        

        // Get selected header parts

        const headerParts = document.querySelectorAll('input[name="header-parts"]:checked');

        headerParts.forEach(part => {

            selectedParts.push(`Header: ${part.nextElementSibling.textContent}`);

        });

        

        // Get selected content parts

        const contentParts = document.querySelectorAll('input[name="content-parts"]:checked');

        contentParts.forEach(part => {

            selectedParts.push(`Content: ${part.nextElementSibling.textContent}`);

        });

        

        // Get selected footer parts

        const footerParts = document.querySelectorAll('input[name="footer-parts"]:checked');

        footerParts.forEach(part => {

            selectedParts.push(`Footer: ${part.nextElementSibling.textContent}`);

        });

        

        // Update the wanted features textarea with parts

        const currentFeatures = keyFeaturesEl.value.trim();

        const baseFeatures = currentFeatures.split('\n').filter(line => 

            line.trim() && 

            !line.includes('Header:') && 

            !line.includes('Content:') && 

            !line.includes('Footer:')

        );

        

        const allFeatures = [...baseFeatures, ...selectedParts].filter(Boolean);

        if (allFeatures.length > 0) {

            keyFeaturesEl.value = allFeatures.join(', ');

        }

    };



    // Add event listeners to parts selection inputs

    document.querySelectorAll('input[name="header-parts"], input[name="content-parts"], input[name="footer-parts"]').forEach(input => {

        input.addEventListener('change', () => {

            updateWantedFeatures();

            updateWantedFeaturesFromParts();

        });

    });



    // Initialize parts features

    updateWantedFeaturesFromParts();

});

</script>



</body>

</html>

