<?php
/**
 * Save Generated Website
 * Saves the generated website code to the affiliates-pages folder
 */

session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $websiteCode = $_POST['website_code'] ?? '';
    $filename = $_POST['filename'] ?? 'ad_' . time() . '.html';
    
    if (empty($websiteCode)) {
        echo json_encode(['success' => false, 'error' => 'No website code provided']);
        exit;
    }
    
    // Ensure affiliates-pages directory exists
    $affiliatesDir = __DIR__ . '/../affiliates-pages';
    if (!is_dir($affiliatesDir)) {
        mkdir($affiliatesDir, 0755, true);
    }
    
    // Sanitize filename
    $filename = preg_replace('/[^a-zA-Z0-9._-]/', '', $filename);
    if (!str_ends_with($filename, '.html')) {
        $filename .= '.html';
    }
    
    $filepath = $affiliatesDir . '/' . $filename;
    
    // Save the website code
    if (file_put_contents($filepath, $websiteCode)) {
        echo json_encode([
            'success' => true, 
            'message' => 'Website saved successfully',
            'filename' => $filename,
            'filepath' => 'affiliates-pages/' . $filename
        ]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to save website']);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
}
?>
