# Campaign and Ad Flow Test

This test verifies the complete flow of:
1. Creating a test campaign
2. Creating an ad and saving it
3. Adding the ad to the campaign
4. Verifying email campaigns can load the ad
5. Verifying the ad can be accessed via acceleratedadz.php

## How to Run the Test

1. **Ensure you are logged in** to the application as a client user
2. **Open your browser** and navigate to:
   ```
   http://your-domain/market/test_campaign_ad_flow.php
   ```
   Or if running locally:
   ```
   http://localhost/market/test_campaign_ad_flow.php
   ```

3. **The test will output** the results in the browser, showing:
   - Campaign creation status
   - Ad creation and saving status
   - Ad-to-campaign linking status
   - Email campaign ad visibility check
   - AcceleratedAdz.php accessibility check
   - Generated URLs for viewing the ad

## What the Test Does

### Step 1: Create Campaign
- Creates a test campaign with type `multi_channel`
- Sets status to `active`
- Campaign name includes timestamp for uniqueness

### Step 2: Create and Save Ad
- Creates a test ad with sample data:
  - Headline: "Amazing Test Product"
  - Description: Test ad description
  - CTA: "Shop Now"
  - Platform: Google Ads
  - Template: Retail
- Saves the ad to the `saved_ads` table

### Step 3: Add Ad to Campaign
- Links the saved ad to the campaign in the `campaign_ads` table
- Sets status to `active`

### Step 4: Check Email Campaign Visibility
- Verifies that the email campaigns page can see campaigns with ads
- Lists all ads found in the campaign

### Step 5: Verify AcceleratedAdz Access
- Checks if the ad can be retrieved via `campaign_ads` table
- Generates URLs for viewing the ad via `acceleratedadz.php`:
  - Direct ad URL: `?campaign_ad=ID&source=campaign`
  - Campaign URL: `?campaign=ID` (random ad from campaign)

## Expected Results

✅ All steps should complete successfully with:
- Campaign ID created
- Ad ID created
- Campaign Ad ID created
- Email campaign can see ads: **Yes**
- AcceleratedAdz accessible: **Yes**
- Generated URLs for viewing the ad

## Manual Verification Steps

After running the test, you can manually verify:

1. **View the ad via AcceleratedAdz:**
   - Open the URL provided in the test output
   - The ad should display correctly with headline, description, and CTA button

2. **Check Email Campaigns:**
   - Navigate to `/client/email_campaigns.php`
   - Click "Create Email Campaign"
   - Click "Insert Ad" button in the email content editor
   - You should see your test campaign in the list
   - Select the campaign and choose an ad to insert
   - The ad HTML should be inserted into the email content

3. **View Campaign Details:**
   - Navigate to `/client/campaigns.php?view=CAMPAIGN_ID`
   - You should see the ad listed in the campaign
   - Click "View Live Ad" to open it via AcceleratedAdz

## Troubleshooting

### Test Fails at Step 1
- Ensure you are logged in
- Check database connection
- Verify `campaigns` table exists

### Test Fails at Step 2
- Verify `saved_ads` table exists
- Check that user_id is valid

### Test Fails at Step 3
- Check `campaign_ads` table structure
- Verify foreign key constraints allow the insert

### Email Campaign Cannot See Ads
- Verify the campaign has status 'active'
- Check that `campaign_ads.status = 'active'`
- Ensure the campaign belongs to the logged-in user

### AcceleratedAdz Cannot Access Ad
- Check that `campaign_ad` ID exists in `campaign_ads` table
- Verify the `saved_ads` table has the linked ad data
- Check that `acceleratedadz.php` file exists and is accessible

## Notes

- The test creates real database records. You may want to clean up test data after testing.
- Campaign type is set to `multi_channel` to work with both Ad Builder and Email Campaigns.
- The test uses the current logged-in user's ID for all operations.

