# Quick Deployment Guide - Namecheap Shared Hosting

## ⚡ Quick Start (5 Minutes)

### 1. Upload Files
Upload entire `affiliate-it.com/market/` directory to your web root via FTP or cPanel File Manager.

### 2. Create Database
- cPanel → MySQL Databases → Create database `mindsybq_market`
- Create database user → Add to database with ALL PRIVILEGES

### 3. Import Database
- cPanel → phpMyAdmin → Select database → Import → Upload `mindsybq_market.sql`

### 4. Configure Database
Create `config/.env` file:
```bash
DB_HOST=localhost
DB_NAME=your_database_name
DB_USER=your_database_user
DB_PASS=your_database_password
DB_CHARSET=utf8mb4
APP_ENV=production
APP_DEBUG=false
```

### 5. Set Permissions
Set these directories to **755** (writable):
- `uploads/`
- `tmp/sessions/`
- `logs/`

### 6. Test
Visit: `https://yourdomain.com/config/test_connection.php`

### 7. Login
- URL: `https://yourdomain.com/login.php`
- Default: `admin@marketingplatform.com` / `admin123`
- **⚠️ CHANGE PASSWORD IMMEDIATELY!**

---

## 📋 Full Instructions

See **DEPLOYMENT_NAMECHEAP.md** for complete step-by-step guide.

---

## 🔧 Common Issues

**500 Error?** → Check `.htaccess` and file permissions

**Database Error?** → Verify credentials and user privileges

**Session Error?** → Ensure `tmp/sessions/` is writable (755)

**Upload Fails?** → Check `uploads/` permissions and PHP limits

---

## 📞 Support

- Check `DEPLOYMENT_NAMECHEAP.md` for detailed troubleshooting
- Review error logs in `logs/` directory
- Namecheap Support: https://www.namecheap.com/support/

