# Marketing Service Platform

A comprehensive multi-domain marketing service platform with 3-tier subscription model for managing Google Ads, Facebook Ads, email campaigns, direct mail, user metrics tracking, and affiliate marketing.

## Multi-Domain Architecture

This platform operates across multiple domains:

- **Main Platform (affiliate-iti.com):** CRM, campaign management, affiliate registration
- **AcceleratedAdz (ai-itinc.com/acceleratedadz):** Public ad serving and display
- **AcceleratedLeadz (ai-itinc.com/acceleratedleadz):** Lead generation and capture

See `docs/SYSTEM_ARCHITECTURE.md` for complete domain and data flow documentation.

## Features

### Core Platform Features
- **3 Pricing Tiers**: Starter ($299/mo), Professional ($599/mo), Enterprise ($999/mo)
- **Campaign Management**: Google Ads, Facebook Ads, Email, and Direct Mail
- **Discount Code Generator**: Create and manage discount codes with usage limits and expiration dates
- **User Metrics Tracking**: Track visitors, conversions, and engagement via UTM parameters
- **Admin Dashboard**: Manage clients, subscriptions, and oversee all campaigns
- **Client Dashboard**: View campaign performance, manage discounts, and analytics

### AcceleratedAdz (Native Ad Platform)
- **Public Ad Serving**: Display ads on ai-itinc.com domain
- **Campaign Types**: Display, Search, Video, Social, Native ads
- **Performance Tracking**: Impressions, clicks, conversions, ROI, CTR, CPC, CPM
- **API Integration**: Create and manage ads via API
- **Public Endpoints**: `https://ai-itinc.com/acceleratedadz?id=123`

### AcceleratedLeadz (Lead Generation)
- **Public Lead Forms**: Capture leads on ai-itinc.com domain
- **Affiliate Tracking**: Automatic attribution via `?ref=PARTNER_CODE`
- **CRM Integration**: Leads automatically added to CRM
- **Email Automation**: 1 email per minute (Mailchimp-style)
- **IMAP Integration**: Process emails from roundbox
- **Public Endpoints**: `https://ai-itinc.com/acceleratedleadz?ref=CODE`

### Affiliate Marketing
- **Partner Registration**: Affiliates register at `affiliate-iti.com/mk/market/client/`
- **Lead Attribution**: Automatic tracking and commission calculation
- **Referral System**: Track clicks and conversions
- **Commission Management**: Automated payout calculations

## Requirements

- PHP 8.1 or higher
- MySQL 8.0 or higher
- Apache/Nginx web server
- phpMyAdmin (optional, for database management)
- Composer (for installing API libraries)

## Installation

1. **Clone or extract the project** to your web server directory

2. **Configure database**:
   - Import `database/schema.sql` into MySQL
   - Update `config/database.php` with your database credentials

3. **Configure API credentials** (optional):
   - Update `config/google_ads_config.php` with Google Ads API credentials
   - Update `config/facebook_config.php` with Facebook Marketing API credentials
   - Update `config/email_config.php` with SendGrid or Mailchimp credentials

4. **Install API libraries** (for full functionality):
   ```bash
   composer require googleads/google-ads-php
   composer require facebook/php-business-sdk
   composer require sendgrid/sendgrid
   ```

5. **Set proper permissions**:
   ```bash
   chmod 755 -R .
   ```

6. **Configure Domains**:
   - Main platform: Point `affiliate-iti.com` to this installation
   - Ad/Learn pages: Point `ai-itinc.com` to same installation (or subdomain)
   - Update CORS headers in API files if using different servers

7. **Access the platform**:
   - Main platform: `https://affiliate-iti.com/mk/market/`
   - Admin login: `https://affiliate-iti.com/mk/market/login.php`
   - Client registration: `https://affiliate-iti.com/mk/market/register.php`
   - Ad display: `https://ai-itinc.com/acceleratedadz?id=123`
   - Lead form: `https://ai-itinc.com/acceleratedleadz?ref=CODE`

## Project Structure

```
taste-of-india/
├── config/              # Configuration files
├── includes/            # Core PHP includes (auth, database, functions)
├── admin/               # Admin dashboard pages
├── client/              # Client dashboard pages
├── api/                 # API integration files
├── assets/              # CSS, JS, images
├── database/            # SQL schema files
├── login.php            # Login page
├── index.php            # Landing page
└── logout.php           # Logout handler
```

## Database Setup

Run the SQL schema file to create all necessary tables:

```bash
mysql -u your_user -p your_database < database/schema.sql
```

Or import via phpMyAdmin:
1. Access phpMyAdmin
2. Select your database
3. Go to Import tab
4. Choose `database/schema.sql`
5. Click Go

## Subscription Tiers

### Starter Plan ($299/month)
- Google Ads: $200/month budget
- Facebook Ads: $150/month budget
- Email: 1,000 contacts, 4 campaigns/month
- Discount codes: 5/month
- Direct mail: 500 postcards quarterly

### Professional Plan ($599/month)
- Google Ads: $500/month budget
- Facebook Ads: $400/month budget
- Email: 5,000 contacts, unlimited campaigns
- Discount codes: Unlimited
- Direct mail: 1,500 postcards monthly
- A/B testing and optimization

### Enterprise Plan ($999/month)
- Google Ads: $1,200/month budget
- Facebook Ads: $800/month budget
- Email: Unlimited contacts and campaigns
- Discount codes: Unlimited with advanced rules
- Direct mail: 5,000 postcards monthly
- API access, advanced analytics, custom integrations

## Usage

### For Clients:
1. Login with your credentials
2. Access dashboard to view metrics and campaigns
3. Create discount codes in the Discounts section
4. View analytics and generate reports
5. Manage email campaigns

### For Admins:
1. Login as admin
2. Manage clients and their subscriptions
3. Oversee all campaigns across clients
4. View revenue and system statistics
5. Upgrade/downgrade client subscriptions

## API Integrations

The platform includes placeholder implementations for:
- **Google Ads API**: Campaign management and performance tracking
- **Facebook Marketing API**: Ad management and metrics
- **SendGrid/Mailchimp**: Email campaign delivery and tracking

Full implementation requires:
- Installing respective PHP SDKs via Composer
- Configuring API credentials
- Completing the integration code in `api/` directory

## Metrics Tracking

Client websites can embed tracking by adding:

```javascript
<script>
var TRACKING_USER_ID = <?= $clientUserId ?>;
</script>
<script src="/assets/js/main.js"></script>
```

Or track manually:
```javascript
trackMetric(userId, {
    conversion_type: 'purchase',
    conversion_value: 99.99,
    discount_code_used: 'SAVE20'
});
```

## Security Notes

- Change default admin password immediately
- Use HTTPS in production
- Keep API credentials secure
- Regularly update dependencies
- Implement proper backup strategy

## Support

For issues or questions:
1. Check database connection settings
2. Verify file permissions
3. Review error logs
4. Ensure PHP extensions are installed (mysqli, curl, json, mbstring)

## License

Proprietary - All rights reserved

