# Quick Start Guide - Local Development

## Fast Setup for XAMPP (Windows)

### 1. Add to Hosts File
Edit `C:\Windows\System32\drivers\etc\hosts` (as Administrator):
```
127.0.0.1  ai-itinc.local
127.0.0.1  affiliate-it.local
```

### 2. Configure Virtual Hosts
Edit `C:\xampp\apache\conf\extra\httpd-vhosts.conf`:
```apache
<VirtualHost *:80>
    ServerName ai-itinc.local
    DocumentRoot "C:/xampp/htdocs/1.2/mk/market"
    <Directory "C:/xampp/htdocs/1.2/mk/market">
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>

<VirtualHost *:80>
    ServerName affiliate-it.local
    DocumentRoot "C:/xampp/htdocs/1.2/mk/market"
    <Directory "C:/xampp/htdocs/1.2/mk/market">
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

### 3. Restart Apache
Restart Apache from XAMPP Control Panel

### 4. Import Database
```sql
CREATE DATABASE mindsybq_market;
USE mindsybq_market;
SOURCE C:/xampp/htdocs/1.2/mk/market/database/schema_main.sql;
```

Or via phpMyAdmin:
- Go to http://localhost/phpmyadmin
- Create database: `mindsybq_market`
- Import: `database/schema_main.sql`

### 5. Configure Database
Edit `mk/market/config/database.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'mindsybq_market');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### 6. Access Locally

**Main Platform:**
- http://ai-itinc.local/mk/market/login.php
- http://affiliate-it.local/mk/market/login.php (same content)

**Public Endpoints:**
- Ads: http://ai-itinc.local/acceleratedadz.php?id=1
- Leads: http://ai-itinc.local/acceleratedleadz.php?ref=TEST123

**Default Admin:**
- Email: `admin@marketingplatform.com`
- Password: `admin123` (change immediately!)

## Testing Connections

### 1. Create Test Ad
1. Login as client
2. Go to AcceleratedAdz
3. Create campaign and ad
4. View ad: http://ai-itinc.local/acceleratedadz.php?id=[AD_ID]

### 2. Test Lead Form
1. Visit: http://ai-itinc.local/acceleratedleadz.php?ref=TEST123
2. Submit form
3. Check CRM: http://ai-itinc.local/mk/market/client/crm.php

### 3. Test Affiliate Tracking
1. Register affiliate partner
2. Get partner code
3. Use in lead form URL: `?ref=PARTNER_CODE`
4. Submit lead
5. Verify attribution in CRM

## Production Deployment

When ready for production:

1. **Upload files** to server
2. **Configure DNS** - point both domains to server
3. **Set up SSL** certificates
4. **Update** `config/database.php` with production credentials
5. **Set up cron** jobs (email worker, IMAP processor)

See `docs/PRODUCTION_DEPLOYMENT.md` for complete guide.

## Need Help?

- **Local Setup:** See `docs/LOCAL_SETUP.md`
- **Production:** See `docs/PRODUCTION_DEPLOYMENT.md`
- **Architecture:** See `docs/SYSTEM_ARCHITECTURE.md`

