# Namecheap Shared Hosting - Setup Summary

## ✅ Files Created/Updated for Deployment

### 1. Production Configuration Files

**`.htaccess`** - Updated for Namecheap shared hosting:
- HTTPS redirect
- Security headers
- File protection
- PHP settings
- Gzip compression
- Browser caching

**`config/production.php`** - Production optimizations:
- Error reporting disabled (logs to file)
- Session configuration for shared hosting
- Memory and execution limits
- Timezone settings

**`config/test_connection.php`** - Database connection test:
- Tests database connection
- Verifies tables exist
- Checks PHP extensions
- Tests file permissions
- **⚠️ DELETE after deployment for security!**

### 2. Documentation Files

**`DEPLOYMENT_NAMECHEAP.md`** - Complete deployment guide:
- Step-by-step instructions
- Database setup
- File upload instructions
- Configuration steps
- Troubleshooting guide

**`DEPLOYMENT_CHECKLIST.md`** - Quick checklist:
- Pre-deployment tasks
- Database setup
- File configuration
- Security checklist
- Testing checklist

**`README_DEPLOYMENT.md`** - Quick start guide:
- 5-minute quick start
- Common issues
- Support resources

### 3. Database Files

**`mindsybq_market.sql`** - Complete database schema:
- All tables created
- Indexes and constraints
- Sample data (admin user, subscription tiers)

### 4. Updated Core Files

**`includes/database.php`** - Added production config loading:
- Auto-loads `config/production.php` if exists
- Optimized for shared hosting

**`config/database.php`** - Database configuration:
- Loads from `.env` file if exists
- Falls back to defaults
- Compatible with Namecheap MySQL

---

## 📦 Deployment Package Contents

When deploying to Namecheap, ensure these are included:

```
affiliate-it.com/market/
├── .htaccess                      ← CRITICAL: Apache config
├── config/
│   ├── database.php              ← Database config
│   ├── production.php            ← Production settings
│   ├── domain_config.php         ← Domain settings
│   ├── test_connection.php       ← Test file (delete after use)
│   └── .env                      ← Create with your credentials
├── includes/                     ← Core PHP files
├── api/                          ← API endpoints
├── client/                       ← Client dashboard
├── admin/                        ← Admin dashboard
├── uploads/                      ← Must be writable (755)
├── tmp/
│   └── sessions/                ← Must be writable (755)
├── logs/                         ← Must be writable (755)
├── DEPLOYMENT_NAMECHEAP.md       ← Full guide
├── DEPLOYMENT_CHECKLIST.md       ← Checklist
└── README_DEPLOYMENT.md          ← Quick start
```

---

## 🔑 Key Configuration Points

### Database Configuration

**Method 1: .env file (Recommended)**
```bash
DB_HOST=localhost
DB_NAME=username_mindsybq_market
DB_USER=username_dbuser
DB_PASS=your_password
```

**Method 2: Direct in database.php**
Edit `config/database.php` with your credentials.

### Domain Configuration

**For root installation:**
- `RewriteBase /` in `.htaccess`
- `MAIN_PATH` = `/` in `domain_config.php`

**For subdirectory:**
- `RewriteBase /subdirectory/` in `.htaccess`
- `MAIN_PATH` = `/subdirectory/` in `domain_config.php`

### File Permissions

**Required:**
- `uploads/` → 755 (writable)
- `tmp/sessions/` → 755 (writable)
- `logs/` → 755 (writable)
- `.env` → 600 (read/write owner only)

---

## 🚀 Quick Deployment Steps

1. **Upload Files** → Via FTP or cPanel File Manager
2. **Create Database** → cPanel MySQL Databases
3. **Import SQL** → phpMyAdmin → Import `mindsybq_market.sql`
4. **Configure .env** → Create `config/.env` with database credentials
5. **Set Permissions** → Make `uploads/`, `tmp/sessions/`, `logs/` writable (755)
6. **Test Connection** → Visit `config/test_connection.php`
7. **Login** → `login.php` with default admin credentials
8. **Change Password** → Immediately update admin password

---

## ⚙️ Namecheap-Specific Settings

### PHP Version
- **Minimum:** PHP 7.4
- **Recommended:** PHP 8.0 or 8.1
- Set via: cPanel → Select PHP Version

### Required Extensions
- `pdo_mysql` ✓
- `mbstring` ✓
- `openssl` ✓
- `json` ✓
- `curl` ✓

### PHP Settings
- `upload_max_filesize` ≥ 10M
- `post_max_size` ≥ 10M
- `memory_limit` ≥ 256M
- `max_execution_time` ≥ 300

### Database Host
- Usually: `localhost`
- Sometimes: `localhost:3306`
- Verify in cPanel → MySQL Databases

---

## 🔒 Security Checklist

- [ ] `.env` file permissions set to 600
- [ ] `.htaccess` blocks access to `.env` files
- [ ] `test_connection.php` deleted after testing
- [ ] Admin password updated
- [ ] Setup files protected or removed
- [ ] Error display disabled in production
- [ ] HTTPS enabled (recommended)

---

## 📝 Default Credentials

**Admin Login:**
- Email: `admin@marketingplatform.com`
- Password: `admin123`
- **⚠️ CHANGE IMMEDIATELY AFTER FIRST LOGIN!**

**Database:**
- Host: `localhost`
- Name: Create via cPanel
- User: Create via cPanel
- Password: Set during creation

---

## 🐛 Troubleshooting

### Common Issues

| Issue | Quick Fix |
|-------|-----------|
| 500 Error | Check `.htaccess` syntax, file permissions |
| Database Error | Verify credentials, check user privileges |
| Session Error | Ensure `tmp/sessions/` is writable (755) |
| Upload Error | Check `uploads/` permissions, PHP limits |
| Page Not Found | Verify `RewriteBase` in `.htaccess` |

### Error Logs

Check these locations for errors:
- `logs/php_errors.log` (if configured)
- cPanel → Error Log
- cPanel → Metrics → Errors

---

## ✅ Testing After Deployment

1. **Database Connection:** `config/test_connection.php`
2. **Login:** `login.php`
3. **Admin Dashboard:** `admin/dashboard.php`
4. **Create Campaign:** `client/acceleratedadz.php`
5. **View Ads:** `public_html/acceleratedadz/`
6. **Lead Form:** `public_html/acceleratedleadz/acceleratedleadz.php`
7. **CRM Leads:** `client/crm.php?tab=leads`

---

## 📞 Support Resources

- **Full Guide:** `DEPLOYMENT_NAMECHEAP.md`
- **Checklist:** `DEPLOYMENT_CHECKLIST.md`
- **Namecheap Support:** https://www.namecheap.com/support/
- **cPanel Docs:** https://docs.cpanel.net/

---

## 🎯 Next Steps After Deployment

1. ✅ Test all critical features
2. ✅ Change admin password
3. ✅ Configure email (if needed)
4. ✅ Set up backups
5. ✅ Monitor error logs
6. ✅ Configure scheduled tasks (if needed)

---

**Deployment Status:** ✅ Ready for Namecheap Shared Hosting

**Last Updated:** October 2025

