# Namecheap Shared Hosting Deployment Guide

## Overview

This guide will help you deploy the Marketing Platform to Namecheap shared hosting.

## Prerequisites

1. **Namecheap Hosting Account** with cPanel access
2. **Database Created** in Namecheap (via cPanel > MySQL Databases)
3. **FTP/cPanel File Manager** access
4. **Domain configured** (ai-itinc.com and/or affiliate-it.com)

---

## Step 1: Prepare Database

### 1.1 Create Database via cPanel

1. Log into **cPanel**
2. Go to **MySQL Databases**
3. Create a new database: `mindsybq_market`
4. Create a new database user (note the username and password)
5. Add user to database with **ALL PRIVILEGES**

**Note:** Namecheap may prefix your database/user names (e.g., `username_mindsybq_market`)

### 1.2 Import Database Schema

**Option A: Via phpMyAdmin (Recommended)**

1. Go to **cPanel > phpMyAdmin**
2. Select your database
3. Click **Import** tab
4. Choose the file: `c:\Users\User\Downloads\mindsybq_market.sql`
5. Click **Go**

**Option B: Via cPanel MySQL Import**

1. Go to **cPanel > MySQL Databases**
2. Click **phpMyAdmin** link
3. Select database
4. Click **Import** tab
5. Upload `mindsybq_market.sql`

### 1.3 Verify Database Import

Check that these tables exist:
- `users`
- `campaigns`
- `acceleratedadz_campaigns`
- `client_leads`
- `email_subscribers`
- (and 30+ other tables)

---

## Step 2: Upload Files

### 2.1 File Upload Methods

**Option A: FTP (Recommended for large files)**
- Use FileZilla or any FTP client
- Connect to your Namecheap FTP server
- Upload all files from `affiliate-it.com/market/` directory

**Option B: cPanel File Manager**
- Go to **cPanel > File Manager**
- Navigate to your domain's root directory (usually `public_html`)
- Upload files (zip first, then extract in cPanel)

### 2.2 Directory Structure on Server

```
public_html/
├── .htaccess                    ← Important: Must be uploaded
├── config/
│   ├── database.php            ← Update with your database credentials
│   └── .env                    ← Create this file (see Step 3)
├── includes/
├── api/
├── client/
├── admin/
├── uploads/                    ← Must be writable (chmod 755)
├── tmp/
│   └── sessions/               ← Must be writable (chmod 755)
└── logs/                       ← Must be writable (chmod 755)
```

**Important:** Upload the entire `affiliate-it.com/market/` directory contents to your web root.

---

## Step 3: Configure Database Connection

### 3.1 Get Database Credentials from cPanel

From **cPanel > MySQL Databases**, note:
- **Database Name** (may be prefixed, e.g., `username_mindsybq_market`)
- **Database User** (may be prefixed, e.g., `username_dbuser`)
- **Database Password** (the one you set)
- **Database Host** (usually `localhost`)

### 3.2 Create `.env` File

Create a file named `.env` in the `config/` directory:

```bash
# Database Configuration
DB_HOST=localhost
DB_NAME=username_mindsybq_market          # Replace with your actual database name
DB_USER=username_dbuser                   # Replace with your actual username
DB_PASS=your_actual_password_here         # Replace with your actual password
DB_CHARSET=utf8mb4

# Application Security
APP_ENV=production
APP_DEBUG=false
SECRET_KEY=generate_a_random_32_character_string_here

# Session Configuration
SESSION_LIFETIME=7200

# Domain Configuration (auto-detected, but can override)
# MAIN_DOMAIN=ai-itinc.com
# AFFILIATE_DOMAIN=affiliate-it.com
```

**Security:** Never commit `.env` to version control!

### 3.3 Alternative: Direct Configuration

If `.env` doesn't work on your hosting, edit `config/database.php` directly:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'username_mindsybq_market');    // Your database name
define('DB_USER', 'username_dbuser');              // Your database user
define('DB_PASS', 'your_actual_password');         // Your password
define('DB_CHARSET', 'utf8mb4');
```

---

## Step 4: Set File Permissions

Set these permissions via **cPanel File Manager** or **FTP**:

```
config/                → 755 (or 750)
uploads/               → 755 (must be writable)
uploads/user_*/        → 755 (created automatically)
tmp/                   → 755
tmp/sessions/          → 755 (must be writable)
logs/                  → 755 (must be writable)
.env                   → 600 (read/write for owner only)
```

**In cPanel File Manager:**
1. Right-click folder/file
2. Select **Change Permissions**
3. Set appropriate permissions

---

## Step 5: Configure Domain Paths

### 5.1 Update Domain Configuration

If your installation is in a subdirectory, edit `config/domain_config.php`:

```php
// If installed in root:
define('MAIN_PATH', '/');

// If installed in subdirectory (e.g., /market/):
define('MAIN_PATH', '/market/');
```

### 5.2 Update .htaccess RewriteBase

Edit `.htaccess` file:

```apache
# If installed in root:
RewriteBase /

# If installed in subdirectory:
RewriteBase /market/
```

---

## Step 6: Test Installation

### 6.1 Test Database Connection

1. Visit: `https://yourdomain.com/config/test_connection.php` (if exists)
2. Or login to check: `https://yourdomain.com/login.php`

### 6.2 Test Admin Login

**Default Admin Credentials:**
- Email: `admin@marketingplatform.com`
- Password: `admin123`

**⚠️ CHANGE THIS PASSWORD IMMEDIATELY!**

1. Go to: `https://yourdomain.com/login.php`
2. Login as admin
3. Go to **Settings** and change password

---

## Step 7: Configure PHP Settings

### 7.1 Check PHP Version

Namecheap usually runs PHP 7.4+ or 8.0+. Verify in **cPanel > Select PHP Version**:
- Minimum: PHP 7.4
- Recommended: PHP 8.0 or 8.1

### 7.2 Required PHP Extensions

Ensure these are enabled:
- `pdo_mysql`
- `mbstring`
- `openssl`
- `json`
- `curl`

Check via **cPanel > Select PHP Version > Extensions**

### 7.3 PHP Settings

In **cPanel > Select PHP Version > Options**, ensure:
- `upload_max_filesize` ≥ 10M
- `post_max_size` ≥ 10M
- `memory_limit` ≥ 256M
- `max_execution_time` ≥ 300

---

## Step 8: Security Checklist

### 8.1 Remove Setup Files

Delete or rename these files after setup:
- `setup_wizard.php`
- `config/setup.php`
- Any test files

### 8.2 Secure .env File

1. Ensure `.env` has permissions `600`
2. Verify `.htaccess` blocks `.env` files
3. Test: Try accessing `https://yourdomain.com/config/.env` (should be blocked)

### 8.3 Update Admin Password

**Immediately** after first login:
1. Login as admin
2. Go to **Settings** or **Profile**
3. Change password to strong password

---

## Step 9: Troubleshooting

### Issue: Database Connection Failed

**Solutions:**
1. Verify database name/user are correct (including prefixes)
2. Check database host (usually `localhost`, but some hosts use `localhost:3306`)
3. Verify user has ALL PRIVILEGES on database
4. Check if database is active in cPanel

### Issue: 500 Internal Server Error

**Solutions:**
1. Check error logs: `cPanel > Error Log`
2. Verify `.htaccess` syntax is correct
3. Check file permissions (especially `uploads/`, `tmp/`, `logs/`)
4. Disable custom PHP settings in `.htaccess` temporarily to test

### Issue: Session Errors

**Solutions:**
1. Check `tmp/sessions/` directory exists and is writable (755)
2. Verify session save path in `config/production.php`
3. Check PHP session settings in cPanel

### Issue: File Upload Errors

**Solutions:**
1. Verify `uploads/` directory exists and is writable (755)
2. Check PHP `upload_max_filesize` and `post_max_size`
3. Check `file_uploads` is enabled in PHP settings

### Issue: Composer/Third-party Libraries

If using Composer libraries (JWT, etc.):
1. Upload `vendor/` directory if exists locally
2. Or install via SSH if Namecheap provides SSH access:
   ```bash
   cd /path/to/your/site
   composer install --no-dev
   ```

---

## Step 10: Post-Deployment

### 10.1 Create Initial Admin User

If database doesn't have admin user:

```sql
INSERT INTO users (email, password_hash, business_name, contact_name, role, status)
VALUES (
    'admin@yourdomain.com',
    '$2y$10$YourHashedPasswordHere',
    'Your Company',
    'Admin Name',
    'admin',
    'active'
);
```

Generate password hash using: `password_hash('yourpassword', PASSWORD_BCRYPT)`

### 10.2 Test Critical Features

1. **Login/Logout** ✓
2. **Create Campaign** ✓
3. **Upload Ad** ✓
4. **View AcceleratedAdz** ✓
5. **Submit Lead Form** ✓
6. **CRM Lead View** ✓

### 10.3 Configure Email (Optional)

If using email features, configure SMTP in:
- **cPanel > Email Accounts** (for IMAP)
- Or set up SendGrid/Mailchimp API keys in `.env`

---

## Namecheap-Specific Notes

### cPanel Access
- URL: Usually `https://yourdomain.com/cpanel` or provided by Namecheap
- Login: Your Namecheap account credentials

### Database Access
- **Host:** Usually `localhost` (verify in cPanel)
- **Port:** Usually `3306` (default)
- **Database Name:** May be prefixed with your cPanel username

### File Paths
- Web root: Usually `/home/username/public_html/` or `/public_html/`
- Check exact path in **cPanel > File Manager**

### PHP Version
- Change via **cPanel > Select PHP Version**
- Recommended: PHP 8.0 or 8.1

---

## Support & Resources

- **Namecheap Support:** https://www.namecheap.com/support/
- **cPanel Documentation:** https://docs.cpanel.net/
- **Project Documentation:** See `docs/` directory

---

## Quick Deployment Checklist

- [ ] Database created and imported
- [ ] Files uploaded to server
- [ ] Database credentials configured (`.env` or `database.php`)
- [ ] File permissions set (uploads, tmp, logs = 755)
- [ ] `.htaccess` uploaded and configured
- [ ] PHP version set to 7.4+ (preferably 8.0+)
- [ ] PHP extensions enabled
- [ ] Admin password changed
- [ ] Test login works
- [ ] Test ad creation works
- [ ] Test lead form works
- [ ] Error logging enabled
- [ ] Security headers active
- [ ] HTTPS enabled (recommended)

---

**Last Updated:** October 2025
**Tested on:** Namecheap Shared Hosting

