# Deployment Checklist - Namecheap Shared Hosting

Use this checklist to ensure everything is configured correctly.

## Pre-Deployment

- [ ] Database schema file ready (`mindsybq_market.sql`)
- [ ] All files uploaded to server
- [ ] FTP/cPanel access credentials ready

## Database Setup

- [ ] Database created in cPanel
- [ ] Database user created
- [ ] User granted ALL PRIVILEGES on database
- [ ] Database imported via phpMyAdmin
- [ ] Verified tables exist (check `users`, `campaigns`, etc.)
- [ ] Database credentials noted (name, user, password, host)

## File Configuration

- [ ] `.env` file created in `config/` directory
- [ ] Database credentials entered in `.env`
- [ ] `.env` file permissions set to 600
- [ ] OR `config/database.php` updated with credentials
- [ ] `.htaccess` file uploaded and present
- [ ] `RewriteBase` in `.htaccess` matches installation path

## File Permissions

- [ ] `uploads/` directory exists and is writable (755)
- [ ] `tmp/` directory exists and is writable (755)
- [ ] `tmp/sessions/` directory exists and is writable (755)
- [ ] `logs/` directory exists and is writable (755)
- [ ] All PHP files have 644 permissions

## PHP Configuration

- [ ] PHP version set to 7.4+ (preferably 8.0+)
- [ ] `pdo_mysql` extension enabled
- [ ] `mbstring` extension enabled
- [ ] `openssl` extension enabled
- [ ] `curl` extension enabled
- [ ] `json` extension enabled
- [ ] `upload_max_filesize` ≥ 10M
- [ ] `post_max_size` ≥ 10M
- [ ] `memory_limit` ≥ 256M

## Security

- [ ] `.env` file not accessible via web (test: `https://domain.com/config/.env`)
- [ ] `config/` directory protected by `.htaccess`
- [ ] Admin password changed from default
- [ ] `test_connection.php` deleted (after testing)
- [ ] Setup files removed or protected
- [ ] HTTPS enabled (recommended)

## Testing

- [ ] Database connection test passes
- [ ] Login page loads
- [ ] Admin login works
- [ ] Can create campaign
- [ ] Can upload ad
- [ ] AcceleratedAdz page displays ads
- [ ] Lead form submission works
- [ ] CRM shows leads
- [ ] No PHP errors in browser
- [ ] Check error logs for any issues

## Post-Deployment

- [ ] Error logging enabled
- [ ] Backup strategy in place
- [ ] Domain DNS configured (if using custom domain)
- [ ] Email notifications working (if configured)
- [ ] Scheduled tasks configured (if needed)

## Troubleshooting Quick Reference

| Issue | Solution |
|-------|----------|
| Database connection failed | Check credentials, verify user has privileges |
| 500 Internal Server Error | Check `.htaccess` syntax, file permissions |
| Session errors | Ensure `tmp/sessions/` is writable |
| File upload fails | Check `uploads/` permissions and PHP limits |
| Page not found | Verify `RewriteBase` in `.htaccess` |
| PHP errors | Check PHP version and extensions |

## Quick Test URLs

After deployment, test these URLs:

1. **Database Test:** `https://yourdomain.com/config/test_connection.php`
2. **Login:** `https://yourdomain.com/login.php`
3. **Admin Dashboard:** `https://yourdomain.com/admin/dashboard.php`
4. **Client Dashboard:** `https://yourdomain.com/client/dashboard.php`
5. **AcceleratedAdz:** `https://yourdomain.com/public_html/acceleratedadz/`
6. **AcceleratedLeadz:** `https://yourdomain.com/public_html/acceleratedleadz/acceleratedleadz.php`

---

**Once all items are checked, your deployment is complete!**

